/*
 * Decompiled with CFR 0.152.
 */
package waves.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import waves.client.ClientEventHandler;
import waves.client.ClientHelpers;
import waves.common.entities.Wave;
import waves.util.RenderHelpers;

public class WaveRenderer
extends EntityRenderer<Wave> {
    public final Tesselator tesselator = Tesselator.getInstance();

    public WaveRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.entityRenderDispatcher.setRenderHitBoxes(false);
        this.entityRenderDispatcher.setRenderShadow(false);
    }

    public void render(Wave wave, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        int i;
        Matrix4f matrix = poseStack.last().pose();
        ResourceLocation texture = wave.getWaveTexture();
        BufferBuilder builder = this.tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
        RenderSystem.setShader(GameRenderer::getPositionColorTexLightmapShader);
        RenderHelpers.translucentTransparency();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        poseStack.pushPose();
        Vector3f[] quad = (Vector3f[])Arrays.stream(ClientHelpers.QUAD).map(Vector3f::new).toArray(Vector3f[]::new);
        for (i = 0; i < 4; ++i) {
            Vector3f vector3 = quad[i];
            vector3.rotate((Quaternionfc)wave.getRotation());
            vector3.mul(wave.getQuadSize());
        }
        for (i = 0; i < 4; ++i) {
            RenderHelpers.drawVertex((VertexConsumer)builder, poseStack, matrix, quad[i], wave.getColor(), ClientHelpers.UVS[i], wave.getPackedLight());
        }
        poseStack.popPose();
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    public boolean shouldRender(Wave wave, Frustum frustum, double camX, double camY, double camZ) {
        if (ClientEventHandler.player != null) {
            Vec3 pos = wave.getPos();
            Vec3 posOld = wave.getPosOld();
            float partialTicks = ClientEventHandler.partialTicks;
            double x = Mth.lerp((double)partialTicks, (double)posOld.x(), (double)pos.x());
            double y = Mth.lerp((double)partialTicks, (double)posOld.y(), (double)pos.y());
            double z = Mth.lerp((double)partialTicks, (double)posOld.z(), (double)pos.z());
            double distanceToParticle = ClientEventHandler.player.position().distanceTo(wave.position());
            return (ClientHelpers.isInFrustum(new Vec3(x, y, z)) || distanceToParticle <= 20.0) && distanceToParticle <= (double)ClientHelpers.getChunkRenderDistance() * 16.0;
        }
        return false;
    }

    public ResourceLocation getTextureLocation(Wave wave) {
        return wave.getWaveTexture();
    }
}

