/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.takesavillage.network;

import java.util.HashMap;
import net.mcreator.takesavillage.TakesavillageMod;
import net.mcreator.takesavillage.procedures.DismissTabOpenedProcedure;
import net.mcreator.takesavillage.procedures.DismissVillagerProcedure;
import net.mcreator.takesavillage.procedures.SummonButtonPressedProcedure;
import net.mcreator.takesavillage.world.inventory.DeedBoxInventoryMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record DeedBoxInventoryButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DeedBoxInventoryButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"takesavillage", (String)"deed_box_inventory_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, DeedBoxInventoryButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new DeedBoxInventoryButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<DeedBoxInventoryButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(DeedBoxInventoryButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                DeedBoxInventoryButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = DeedBoxInventoryMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            DismissVillagerProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            DismissTabOpenedProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            SummonButtonPressedProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TakesavillageMod.addNetworkMessage(TYPE, STREAM_CODEC, DeedBoxInventoryButtonMessage::handleData);
    }
}

