/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import com.google.common.collect.Maps;
import com.jaquadro.minecraft.storagedrawers.config.ModClientConfig;
import com.jaquadro.minecraft.storagedrawers.config.PlayerConfigSetting;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerConfig {
    public static final Map<UUID, Map<String, PlayerConfigSetting<?>>> serverPlayerConfigSettings = Maps.newHashMap();

    static Optional<Boolean> getBooleanValue(Player player, String key) {
        if (!serverPlayerConfigSettings.containsKey(player.getUUID())) {
            return Optional.empty();
        }
        Map<String, PlayerConfigSetting<?>> map = serverPlayerConfigSettings.get(player.getUUID());
        if (!map.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.of((Boolean)map.get(key).getValue());
    }

    public static boolean getInvertShift(Player player) {
        Optional<Boolean> val = PlayerConfig.getBooleanValue(player, "invertShift");
        if (val.isEmpty()) {
            if (!(player instanceof ServerPlayer)) {
                return (Boolean)ModClientConfig.INSTANCE.GENERAL.invertShift.get();
            }
            return false;
        }
        return val.get();
    }

    public static boolean getInvertClick(Player player) {
        Optional<Boolean> val = PlayerConfig.getBooleanValue(player, "invertClick");
        if (val.isEmpty()) {
            if (!(player instanceof ServerPlayer)) {
                return (Boolean)ModClientConfig.INSTANCE.GENERAL.invertClick.get();
            }
            return false;
        }
        return val.get();
    }
}

