/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.client.model.DrawerModelStore;
import com.jaquadro.minecraft.storagedrawers.client.model.context.DrawerModelContext;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class DecoratedDrawerModel
implements BakedModel {
    protected final BakedModel mainModel;
    protected final DrawerModelStore.DecorationSet overlays;

    protected DecoratedDrawerModel(BakedModel mainModel, DrawerModelStore.DecorationSet overlays) {
        this.mainModel = mainModel;
        this.overlays = overlays;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState blockState, @Nullable Direction direction, RandomSource randomSource) {
        return this.mainModel.getQuads(blockState, direction, randomSource);
    }

    public boolean useAmbientOcclusion() {
        return this.mainModel.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.mainModel.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.mainModel.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.mainModel.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.mainModel.getParticleIcon();
    }

    public ItemTransforms getTransforms() {
        return this.mainModel.getTransforms();
    }

    public ItemOverrides getOverrides() {
        return this.mainModel.getOverrides();
    }

    public void emitDecoratedQuads(DrawerModelContext context, Consumer<BakedModel> emitModel) {
        IDrawerGroup group;
        DrawerModelStore.DynamicPart priorityPart;
        boolean isClaimed;
        Direction dir = (Direction)context.state().getValue((Property)BlockDrawers.FACING);
        boolean half = false;
        Block block = context.state().getBlock();
        if (block instanceof BlockDrawers) {
            BlockDrawers drawers = (BlockDrawers)block;
            half = drawers.isHalfDepth();
        }
        IDrawerAttributes attr = context.attr();
        IProtectable protectable = context.protectable();
        boolean isLocked = attr.isItemLocked(LockAttribute.LOCK_EMPTY) || attr.isItemLocked(LockAttribute.LOCK_POPULATED);
        boolean bl = isClaimed = protectable != null && protectable.getOwner() != null;
        if (isLocked && isClaimed) {
            emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.LOCK_CLAIM, dir, half));
        } else if (isLocked) {
            emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.LOCK, dir, half));
        } else if (isClaimed) {
            emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.CLAIM, dir, half));
        }
        switch (attr.getPriority()) {
            case 1: {
                DrawerModelStore.DynamicPart dynamicPart = DrawerModelStore.DynamicPart.PRIORITY_P1;
                break;
            }
            case 2: {
                DrawerModelStore.DynamicPart dynamicPart = DrawerModelStore.DynamicPart.PRIORITY_P2;
                break;
            }
            case -1: {
                DrawerModelStore.DynamicPart dynamicPart = DrawerModelStore.DynamicPart.PRIORITY_N1;
                break;
            }
            case -2: {
                DrawerModelStore.DynamicPart dynamicPart = DrawerModelStore.DynamicPart.PRIORITY_N2;
                break;
            }
            default: {
                DrawerModelStore.DynamicPart dynamicPart = priorityPart = null;
            }
        }
        if (priorityPart != null) {
            emitModel.accept(DrawerModelStore.getModel(priorityPart, dir, half));
        }
        if (attr.isVoid()) {
            emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.VOID, dir, half));
        }
        if (attr.isConcealed()) {
            emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.SHROUD, dir, half));
        }
        if (attr.hasFillLevel()) {
            if (block instanceof BlockCompDrawers) {
                BlockCompDrawers compBlock = (BlockCompDrawers)block;
                count = compBlock.getDrawerCount();
                emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.INDICATOR_COMP, dir, half, count));
            } else if (block instanceof BlockStandardDrawers) {
                BlockStandardDrawers stdBlock = (BlockStandardDrawers)block;
                count = stdBlock.getDrawerCount();
                emitModel.accept(DrawerModelStore.getModel(DrawerModelStore.DynamicPart.INDICATOR, dir, half, count));
            }
        }
        if (block instanceof BlockStandardDrawers && (group = context.group()) != null) {
            int count = group.getDrawerCount();
            DrawerModelStore.DynamicPart[] groupMissingSlots = DrawerModelStore.missingSlots[count - 1];
            for (int i = 0; i < groupMissingSlots.length; ++i) {
                if (!group.getDrawer(i).isMissing()) continue;
                emitModel.accept(DrawerModelStore.getModel(groupMissingSlots[i], dir, half, count));
            }
        }
    }
}

