/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.modelprops;

import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlockEntity;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedMaterials;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.client.model.ModelContextSupplier;
import com.jaquadro.minecraft.storagedrawers.client.model.context.FramedModelContext;
import com.jaquadro.minecraft.storagedrawers.components.item.FrameData;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;

public class FramedModelProperties
implements ModelContextSupplier<FramedModelContext> {
    public static final FramedModelProperties INSTANCE = new FramedModelProperties();
    public static final ModelProperty<IFramedMaterials> MATERIAL = new ModelProperty();

    public static ModelData getModelData(IFramedBlockEntity blockEntity) {
        return ModelData.builder().with(MATERIAL, (Object)blockEntity.material()).build();
    }

    @Override
    public FramedModelContext makeContext(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType type) {
        return new FramedModelContext(state, side, rand, type).materialData(new MaterialData((IFramedMaterials)extraData.get(MATERIAL)));
    }

    @Override
    public FramedModelContext makeContext(ItemStack stack) {
        MaterialData data = ((FrameData)stack.getOrDefault((DataComponentType)ModDataComponents.FRAME_DATA.get(), (Object)FrameData.EMPTY)).asMaterialData();
        Block block = Blocks.AIR;
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            block = blockItem.getBlock();
        }
        return new FramedModelContext(block.defaultBlockState()).materialData(data);
    }
}

