/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.block.entity;

import de.sarocesch.sarosroadblocksmod.init.SarosRoadBlocksModModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RoadBlockEntity
extends BlockEntity {
    private String textureId = "default";

    public RoadBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SarosRoadBlocksModModBlockEntities.ROAD_BLOCK_ENTITY.get(), pos, state);
    }

    public void setTextureId(String textureId) {
        this.textureId = textureId;
        this.setChanged();
        Level level = this.getLevel();
        if (level != null && !level.isClientSide()) {
            BlockState state = this.getBlockState();
            level.sendBlockUpdated(this.getBlockPos(), state, state, 3);
        }
    }

    public String getTextureId() {
        return this.textureId;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putString("TextureId", this.textureId);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("TextureId")) {
            this.textureId = tag.getString("TextureId");
        }
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        Level level;
        super.handleUpdateTag(tag, provider);
        if (tag.contains("TextureId")) {
            this.textureId = tag.getString("TextureId");
        }
        if ((level = this.getLevel()) != null && level.isClientSide()) {
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            level.getModelDataManager().requestRefresh((BlockEntity)this);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        tag.putString("TextureId", this.textureId);
        return tag;
    }
}

