/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.particle;

import com.leclowndu93150.particlerain.ParticleRainConfig;
import com.leclowndu93150.particlerain.particle.WeatherParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class FogParticle
extends WeatherParticle {
    private static final float FADE_DURATION = 40.0f;
    private float targetAlpha = 1.0f;
    private float baseQuadSize;

    private FogParticle(ClientLevel level, double x, double y, double z, SpriteSet provider) {
        super(level, x, y, z);
        this.setSprite(provider.get(level.getRandom()));
        this.lifetime = ParticleRainConfig.particleRadius * 5;
        double distance = Minecraft.getInstance().cameraEntity.position().distanceTo(new Vec3(x, y, z));
        this.quadSize = (float)((double)ParticleRainConfig.FogOptions.size / distance);
        this.baseQuadSize = (float)((double)ParticleRainConfig.FogOptions.size / distance);
        Color color = new Color(((Biome)this.level.getBiome((BlockPos)this.pos).value()).getFogColor()).darker();
        this.rCol = (float)color.getRed() / 255.0f;
        this.gCol = (float)color.getGreen() / 255.0f;
        this.bCol = (float)color.getBlue() / 255.0f;
        this.oRoll = this.roll = level.random.nextFloat() * (float)Math.PI;
        this.xd = this.gravity / 3.0f;
        this.zd = this.gravity / 3.0f;
        this.gravity = ParticleRainConfig.FogOptions.gravity;
    }

    @Override
    public void tick() {
        super.tick();
        double camdist = Minecraft.getInstance().cameraEntity.position().distanceTo(new Vec3(this.x, this.y, this.z));
        this.quadSize = (float)camdist / 2.0f;
        BlockState fallingTowards = this.level.getBlockState(this.pos.offset(3, -1, 3));
        BlockPos blockPos = this.pos.offset(2, -4, 2);
        if (!(this.level.getHeight(Heightmap.Types.MOTION_BLOCKING, blockPos.getX(), blockPos.getZ()) < blockPos.getY() && fallingTowards.getFluidState().isEmpty() || this.shouldFadeOut)) {
            this.shouldFadeOut = true;
        }
        if (this.onGround) {
            this.remove();
        }
    }

    @Override
    public void fadeIn() {
        if ((float)this.age < 40.0f) {
            float progress = (float)this.age / 40.0f;
            this.alpha = Mth.lerp((float)progress, (float)0.0f, (float)this.targetAlpha);
            this.quadSize = Mth.lerp((float)progress, (float)0.0f, (float)this.baseQuadSize);
        }
    }

    @Override
    public void fadeOut() {
        float progress = Math.min(((float)this.age - ((float)this.lifetime - 40.0f)) / 40.0f, 1.0f);
        if (progress > 0.0f) {
            this.alpha = Mth.lerp((float)progress, (float)this.targetAlpha, (float)0.0f);
            this.quadSize = Mth.lerp((float)progress, (float)this.baseQuadSize, (float)0.0f);
            if (progress >= 1.0f) {
                this.remove();
            }
        }
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float f) {
        Vec3 camPos = camera.getPosition();
        float x = (float)(Mth.lerp((double)f, (double)this.xo, (double)this.x) - camPos.x());
        float y = (float)(Mth.lerp((double)f, (double)this.yo, (double)this.y) - camPos.y());
        float z = (float)(Mth.lerp((double)f, (double)this.zo, (double)this.z) - camPos.z());
        Vector3f localPos = new Vector3f(x, y, z);
        Quaternionf quaternion = Axis.YP.rotation((float)Math.atan2(x, z) + (float)Math.PI);
        float yAngle = (float)Math.asin(y / localPos.length());
        quaternion.rotateX(yAngle);
        quaternion.rotateZ((float)Math.atan2(x, z));
        if (yAngle < -1.0f) {
            this.shouldFadeOut = true;
        }
        quaternion.rotateZ(Mth.lerp((float)f, (float)this.oRoll, (float)this.roll));
        this.renderRotatedQuad(vertexConsumer, quaternion, x, y, z, f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet provider;

        public DefaultFactory(SpriteSet provider) {
            this.provider = provider;
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new FogParticle(level, x, y, z, this.provider);
        }
    }
}

