/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain;

import com.leclowndu93150.particlerain.ParticleRainConfig;
import com.leclowndu93150.particlerain.ParticleRegistry;
import com.leclowndu93150.particlerain.WeatherParticleSpawner;
import com.leclowndu93150.particlerain.particle.DustMoteParticle;
import com.leclowndu93150.particlerain.particle.DustParticle;
import com.leclowndu93150.particlerain.particle.FogParticle;
import com.leclowndu93150.particlerain.particle.GroundFogParticle;
import com.leclowndu93150.particlerain.particle.RainParticle;
import com.leclowndu93150.particlerain.particle.RippleParticle;
import com.leclowndu93150.particlerain.particle.ShrubParticle;
import com.leclowndu93150.particlerain.particle.SnowParticle;
import com.leclowndu93150.particlerain.particle.StreakParticle;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.IntUnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Math;
import org.slf4j.Logger;

@Mod(value="particlerain")
public class ParticleRainClient {
    public static final String MODID = "particlerain";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static int particleCount;
    public static int fogCount;
    public static final IntUnaryOperator desaturateOperation;

    public ParticleRainClient(IEventBus modEventBus, ModContainer modContainer) {
        ParticleRegistry.SOUND_EVENTS.register(modEventBus);
        ParticleRegistry.PARTICLE_TYPES.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ParticleRainConfig.SPEC, "prettyrain-client.toml");
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        modEventBus.addListener(this::registerParticleFactories);
        NeoForge.EVENT_BUS.addListener(this::onClientTick);
        NeoForge.EVENT_BUS.addListener(this::onJoin);
        NeoForge.EVENT_BUS.addListener(this::registerClientCommands);
    }

    private void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ParticleRegistry.RAIN.get(), RainParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.SNOW.get(), SnowParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.DUST_MOTE.get(), DustMoteParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.DUST.get(), DustParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.SHRUB.get(), ShrubParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.FOG.get(), FogParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.GROUND_FOG.get(), GroundFogParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.RIPPLE.get(), RippleParticle.DefaultFactory::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.STREAK.get(), StreakParticle.DefaultFactory::new);
    }

    private void registerClientCommands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)MODID).executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)String.format("Particle count: %d/%d", particleCount, ParticleRainConfig.maxParticleAmount)));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)String.format("Fog density: %d/%d", fogCount, ParticleRainConfig.groundFogDensity)));
            return 0;
        }));
    }

    private void onJoin(ClientPlayerNetworkEvent.LoggingIn event) {
        particleCount = 0;
        fogCount = 0;
    }

    private void onClientTick(ClientTickEvent.Post event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (!minecraft.isPaused() && minecraft.level != null && minecraft.getCameraEntity() != null) {
            WeatherParticleSpawner.update(minecraft.level, minecraft.getCameraEntity(), minecraft.getFrameTimeNs());
        }
    }

    public static void applyWaterTint(TextureSheetParticle particle, ClientLevel clientLevel, BlockPos blockPos) {
        Color waterColor = new Color(BiomeColors.getAverageWaterColor((BlockAndTintGetter)clientLevel, (BlockPos)blockPos));
        Color fogColor = new Color(((Biome)clientLevel.getBiome(blockPos).value()).getFogColor());
        float rCol = Mth.lerp((float)((float)ParticleRainConfig.tintMix / 100.0f), (float)waterColor.getRed(), (float)fogColor.getRed()) / 255.0f;
        float gCol = Mth.lerp((float)((float)ParticleRainConfig.tintMix / 100.0f), (float)waterColor.getGreen(), (float)fogColor.getGreen()) / 255.0f;
        float bCol = Mth.lerp((float)((float)ParticleRainConfig.tintMix / 100.0f), (float)waterColor.getBlue(), (float)fogColor.getBlue()) / 255.0f;
        particle.setColor(rCol, gCol, bCol);
    }

    public static NativeImage loadTexture(ResourceLocation resourceLocation) throws IOException {
        NativeImage nativeImage;
        Resource resource = Minecraft.getInstance().getResourceManager().getResourceOrThrow(resourceLocation);
        try (InputStream inputStream = resource.open();){
            nativeImage = NativeImage.read((InputStream)inputStream);
        }
        return nativeImage;
    }

    public static SpriteContents splitImage(NativeImage image, int segment, String id) {
        int size = image.getWidth();
        NativeImage sprite = new NativeImage(size, size, false);
        image.copyRect(sprite, 0, size * segment, 0, 0, size, size, true, true);
        return new SpriteContents(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)(id + segment)), new FrameSize(size, size), sprite, ResourceMetadata.EMPTY);
    }

    public static double yLevelWindAdjustment(double y) {
        return Math.clamp((double)0.01, (double)1.0, (double)((y - 64.0) / 40.0));
    }

    public static int getRippleResolution(List<SpriteContents> contents) {
        int resolution;
        if (ParticleRainConfig.useResourcepackResolution) {
            ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace((String)"big_smoke_0");
            for (SpriteContents spriteContents : contents) {
                if (!spriteContents.name().equals((Object)resourceLocation) || spriteContents.width() >= 256) continue;
                return spriteContents.width();
            }
        }
        if ((resolution = ParticleRainConfig.rippleResolution) < 4) {
            resolution = 4;
        }
        if (resolution > 256) {
            resolution = 256;
        }
        return resolution;
    }

    public static SpriteContents generateRipple(int i, int size) {
        float radius = (float)size / 2.0f / 8.0f * (float)(i + 1);
        NativeImage image = new NativeImage(size, size, true);
        Color color = Color.WHITE;
        int colorint = (color.getAlpha() & 0xFF) << 24 | (color.getRed() & 0xFF) << 16 | (color.getGreen() & 0xFF) << 8 | color.getBlue() & 0xFF;
        ParticleRainClient.generateBresenhamCircle(image, size, (int)Math.clamp((float)1.0f, (float)((float)size / 2.0f - 1.0f), (float)radius), colorint);
        return new SpriteContents(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)("ripple" + i)), new FrameSize(size, size), image, ResourceMetadata.EMPTY);
    }

    public static void generateBresenhamCircle(NativeImage image, int imgSize, int radius, int colorint) {
        int centerX = imgSize / 2;
        int centerY = imgSize / 2;
        int x = 0;
        int y = radius;
        int d = 3 - 2 * radius;
        ParticleRainClient.drawCirclePixel(centerX, centerY, x, y, image, colorint);
        while (y >= x) {
            d = d > 0 ? d + 4 * (x - --y) + 10 : d + 4 * x + 6;
            ParticleRainClient.drawCirclePixel(centerX, centerY, ++x, y, image, colorint);
        }
    }

    private static void drawCirclePixel(int xc, int yc, int x, int y, NativeImage img, int col) {
        img.setPixelRGBA(xc + x, yc + y, col);
        img.setPixelRGBA(xc - x, yc + y, col);
        img.setPixelRGBA(xc + x, yc - y, col);
        img.setPixelRGBA(xc - x, yc - y, col);
        img.setPixelRGBA(xc + y, yc + x, col);
        img.setPixelRGBA(xc - y, yc + x, col);
        img.setPixelRGBA(xc + y, yc - x, col);
        img.setPixelRGBA(xc - y, yc - x, col);
    }

    static {
        desaturateOperation = rgba -> {
            Color col = new Color(rgba, true);
            int gray = Math.max((int)Math.max((int)col.getRed(), (int)col.getGreen()), (int)col.getBlue());
            return (col.getAlpha() & 0xFF) << 24 | (gray & 0xFF) << 16 | (gray & 0xFF) << 8 | gray & 0xFF;
        };
    }
}

