/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.nirvana_lib.loaders.neoforge;

import com.clefal.nirvana_lib.client.lang.ILangEntry;
import com.clefal.nirvana_lib.client.lang.LangPair;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.LanguageProvider;

public abstract class ConvenientLanguageProvider
extends LanguageProvider {
    private final AccessibleLanguageProvider upsideDown;
    private static final String NORMAL_CHARS = "abcdefghijklmn\u00f1opqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_,;.?!/\\'";
    private static final String UPSIDE_DOWN_CHARS = "\u0250q\u0254p\u01dd\u025fb\u0265\u0131\u0638\u029e\u05df\u026fuuodb\u0279s\u0287n\u028c\u028dx\u028ez\u2c6f\u15fa\u0186\u15e1\u018e\u2132\u2141HI\u017f\u029e\ua780WNO\u0500\u1f49\u1d1aS\u27d8\u2229\u039bMX\u028eZ0\u0196\u1105\u0190\u3123\u03db9\u312586\u203e'\u061b\u02d9\u00bf\u00a1/\\,";

    public ConvenientLanguageProvider(PackOutput output, String modid, String locale) {
        super(output, modid, locale);
        this.upsideDown = new AccessibleLanguageProvider(output, modid, locale + "_ud");
    }

    public abstract List<ILangEntry> getAllEntry();

    protected void addTranslations() {
        for (ILangEntry entry : this.getAllEntry()) {
            for (LangPair langPair : entry.provide().get()) {
                this.add(langPair.getKey(), langPair.getValue());
            }
        }
    }

    private String toUpsideDown(String normal) {
        char[] ud = new char[normal.length()];
        for (int i = 0; i < normal.length(); ++i) {
            char c = normal.charAt(i);
            if (c == '%') {
                Object fmtArg = "";
                while (Character.isDigit(c) || c == '%' || c == '$' || c == 's' || c == 'd') {
                    fmtArg = (String)fmtArg + c;
                    c = ++i == normal.length() ? (char)'\u0000' : normal.charAt(i);
                }
                --i;
                for (int j = 0; j < ((String)fmtArg).length(); ++j) {
                    ud[normal.length() - 1 - i + j] = ((String)fmtArg).charAt(j);
                }
                continue;
            }
            int lookup = NORMAL_CHARS.indexOf(c);
            if (lookup >= 0) {
                c = UPSIDE_DOWN_CHARS.charAt(lookup);
            }
            ud[normal.length() - 1 - i] = c;
        }
        return new String(ud);
    }

    public void add(String key, String value) {
        super.add(key, value);
        this.upsideDown.add(key, this.toUpsideDown(value));
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        return CompletableFuture.allOf(super.run(cache), this.upsideDown.run(cache));
    }

    static {
        if (NORMAL_CHARS.length() != UPSIDE_DOWN_CHARS.length()) {
            throw new AssertionError((Object)"Char maps do not match in length!");
        }
    }

    private static class AccessibleLanguageProvider
    extends LanguageProvider {
        public AccessibleLanguageProvider(PackOutput packOutput, String modid, String locale) {
            super(packOutput, modid, locale);
        }

        public void add(@Nullable String key, @Nullable String value) {
            super.add(key, value);
        }

        protected void addTranslations() {
        }
    }
}

