/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.lootbeams.config.configs;

import com.clefal.nirvana_lib.utils.ModUtils;
import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import me.clefal.lootbeams.utils.ResourceLocationHelper;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import me.fzzyhmstrs.fzzy_config.api.RegisterType;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.config.ConfigSection;
import me.fzzyhmstrs.fzzy_config.entry.Entry;
import me.fzzyhmstrs.fzzy_config.entry.EntryChecker;
import me.fzzyhmstrs.fzzy_config.util.AllowableStrings;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedIdentifierMap;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedMap;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedSet;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedIdentifier;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedColor;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedString;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;

public class LightConfig
extends Config {
    public static LightConfig lightConfig = (LightConfig)ConfigApiJava.registerAndLoadConfig(LightConfig::new, (RegisterType)RegisterType.CLIENT);
    public Beam beam = new Beam();
    public Glow glow = new Glow();
    public CustomColorSetting customColorSetting = new CustomColorSetting();
    public LightEffectFilter lightEffectFilter = new LightEffectFilter();

    public LightConfig() {
        super(ResourceLocationHelper.fromNameAndPath("lootbeams", "light_config"));
    }

    public static void init() {
    }

    public static class Beam
    extends ConfigSection {
        public boolean enable_beam = true;
        public ValidatedInt beam_fade_in_time = new ValidatedInt(10, 100, 1);
        public ValidatedFloat beam_fade_in_distance = new ValidatedFloat(15.0f, 100.0f, 1.0f);
        public ValidatedFloat beam_radius = new ValidatedFloat(0.55f, 5.0f, 0.0f);
        public ValidatedFloat beam_height = new ValidatedFloat(1.5f, 10.0f, 0.0f);
        public ValidatedFloat beam_y_offset = new ValidatedFloat(0.5f, 30.0f, -30.0f);
        public ValidatedFloat beam_alpha = new ValidatedFloat(0.75f, 1.0f, 0.0f);
        public boolean common_shorter_beam = true;
        public boolean solid_beam = true;
        public boolean require_on_ground = true;
        public boolean allow_use_name_color_as_beam_color = true;
    }

    public static class Glow
    extends ConfigSection {
        public boolean enable_glow = true;
        public ValidatedFloat glow_effect_radius = new ValidatedFloat(0.5f, 1.0f, 1.0E-5f);
    }

    public static class CustomColorSetting
    extends ConfigSection {
        public boolean enable_custom_color = false;
        public ValidatedIdentifierMap<ValidatedColor.ColorHolder> color_override_by_name = new ValidatedIdentifierMap(new LinkedHashMap(), ValidatedIdentifier.ofRegistry((ResourceLocation)BuiltInRegistries.ITEM.getDefaultKey(), (Registry)BuiltInRegistries.ITEM), (Entry)new ValidatedColor(255, 255, 255, 255));
        public ValidatedMap<String, ValidatedColor.ColorHolder> color_override_by_tag = new ValidatedMap(new LinkedHashMap(), (Entry)new ValidatedString("#minecraft:air", "#.+:.+"), (Entry)new ValidatedColor(255, 255, 255, 255));
        public ValidatedMap<String, ValidatedColor.ColorHolder> color_override_by_modid = new ValidatedMap(new LinkedHashMap(), (Entry)new ValidatedString("lootbeams", (EntryChecker)new AllowableStrings(x -> !x.isBlank() && !x.contains("#"), ModUtils::getModList)), (Entry)new ValidatedColor(255, 255, 255, 255));
    }

    public static class LightEffectFilter
    extends ConfigSection {
        public boolean all_item = false;
        public boolean only_rare = false;
        public boolean only_equipment = true;
        private final List<ResourceLocation> defaultVanillaWhitelist = ImmutableList.of((Object)"minecraft:totem_of_undying", (Object)"minecraft:end_crystal", (Object)"minecraft:nether_star", (Object)"minecraft:wither_skeleton_skull", (Object)"minecraft:diamond").stream().map(ResourceLocationHelper::fromWholeName).toList();
        public ValidatedSet<ResourceLocation> whitelist_by_name = ValidatedIdentifier.ofRegistry((ResourceLocation)BuiltInRegistries.ITEM.getDefaultKey(), (Registry)BuiltInRegistries.ITEM).toSet(this.defaultVanillaWhitelist);
        public ValidatedSet<String> whitelist_by_tag = new ValidatedString("#minecraft:air", "#.+:.+").toSet((Object[])new String[0]);
        public ValidatedSet<String> whitelist_by_modid = new ValidatedString("lootbeams", (EntryChecker)new AllowableStrings(x -> !x.isBlank() && !x.contains("#"), ModUtils::getModList)).toSet((Object[])new String[0]);
        public ValidatedSet<ResourceLocation> blacklist_by_name = ValidatedIdentifier.ofRegistry((ResourceLocation)BuiltInRegistries.ITEM.getDefaultKey(), (Registry)BuiltInRegistries.ITEM).toSet((Object[])new ResourceLocation[0]);
        public ValidatedSet<String> blacklist_by_tag = new ValidatedString("#minecraft:air", "#.+:.+").toSet((Object[])new String[0]);
        public ValidatedSet<String> blacklist_by_modid = new ValidatedString("lootbeams", (EntryChecker)new AllowableStrings(x -> !x.isBlank() && !x.contains("#"), ModUtils::getModList)).toSet((Object[])new String[0]);
    }
}

