/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.plant;

import jeresources.compatibility.CompatBase;
import jeresources.entry.PlantEntry;
import jeresources.util.PlantHelper;
import jeresources.util.RenderHelper;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class PlantWrapper
implements IRecipeCategoryExtension<PlantEntry> {
    private BlockState state;
    private Property<?> ageProperty;
    private long timer = -1L;
    private static final int TICKS = 500;

    public void drawInfo(PlantEntry recipe, int recipeWidth, int recipeHeight, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderHelper.renderBlock(guiGraphics, this.getFarmland(recipe), 30.0f, 30.0f, -10.0f, 20.0f, 20.0f);
        RenderHelper.renderBlock(guiGraphics, this.getBlockState(recipe), 30.0f, 12.0f, 10.0f, 20.0f, 20.0f);
    }

    private BlockState getBlockState(PlantEntry recipe) {
        if (this.state == null) {
            this.state = recipe.getPlantState() != null ? recipe.getPlantState() : (recipe.getPlant() != null ? PlantHelper.getPlant(recipe.getPlant(), (BlockGetter)CompatBase.getLevel(), BlockPos.ZERO) : Block.byItem((Item)recipe.getPlantItemStack().getItem()).defaultBlockState());
            if (recipe.getAgeProperty() != null) {
                this.ageProperty = recipe.getAgeProperty();
            } else {
                this.state.getProperties().stream().filter(p -> p.getName().equals("age")).findAny().ifPresent(property -> {
                    this.ageProperty = property;
                });
            }
        }
        if (this.ageProperty != null) {
            if (this.timer == -1L) {
                this.timer = System.currentTimeMillis() + 500L;
            } else if (System.currentTimeMillis() > this.timer) {
                this.state = (BlockState)this.state.cycle(this.ageProperty);
                this.timer = System.currentTimeMillis() + 500L;
            }
        }
        return this.state;
    }

    private BlockState getFarmland(PlantEntry recipe) {
        if (recipe.getSoil() != null) {
            return recipe.getSoil();
        }
        return Blocks.FARMLAND.defaultBlockState();
    }
}

