/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.batching;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceObjectImmutablePair;
import it.unimi.dsi.fastutil.objects.ReferenceObjectPair;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.raphimc.immediatelyfast.feature.batching.BatchingBuffer;
import net.raphimc.immediatelyfast.feature.batching.BatchingBuffers;
import net.raphimc.immediatelyfast.feature.batching.BatchingRenderLayers;
import net.raphimc.immediatelyfast.feature.batching.LightingState;

public class ItemModelBatchingBuffer
extends BatchingBuffer {
    private final Object2ObjectMap<ReferenceObjectPair<RenderType, LightingState>, RenderType> lightingRenderLayers = new Object2ObjectOpenHashMap();
    private final Reference2ObjectMap<RenderType, ReferenceSet<RenderType>> renderLayerMap = new Reference2ObjectOpenHashMap();

    public ItemModelBatchingBuffer() {
        super(BatchingBuffers.createLayerBuffers((RenderType[])Minecraft.getInstance().renderBuffers().bufferSource().fixedBuffers.keySet().stream().filter(layer -> layer.name.contains("glint")).toArray(RenderType[]::new)));
    }

    @Override
    public VertexConsumer getBuffer(RenderType layer) {
        if (this.fixedBuffers.containsKey(layer)) {
            return super.getBuffer(layer);
        }
        LightingState lightingState = LightingState.current();
        RenderType newLayer = (RenderType)this.lightingRenderLayers.computeIfAbsent((Object)new ReferenceObjectImmutablePair((Object)layer, (Object)lightingState), key -> new BatchingRenderLayers.WrappedRenderLayer(layer, lightingState::saveAndApply, lightingState::revert));
        ((ReferenceSet)this.renderLayerMap.computeIfAbsent((Object)layer, key -> new ReferenceOpenHashSet())).add((Object)newLayer);
        return super.getBuffer(newLayer);
    }

    @Override
    public void endBatch(RenderType layer) {
        Set renderLayers = (Set)this.renderLayerMap.remove((Object)layer);
        if (renderLayers != null) {
            for (RenderType renderLayer : renderLayers) {
                super.endBatch(renderLayer);
            }
        } else {
            super.endBatch(layer);
        }
    }

    @Override
    public void endBatch() {
        RenderSystem.enableBlend();
        super.endBatch();
        RenderSystem.disableBlend();
        this.lightingRenderLayers.clear();
        this.renderLayerMap.clear();
    }

    @Override
    public void close() {
        super.close();
        this.lightingRenderLayers.clear();
        this.renderLayerMap.clear();
    }
}

