/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.property;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.util.Utils;

public enum HorizontalRotation implements StringRepresentable
{
    UP(dir -> Direction.UP, Shapes.box((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)1.0), Shapes.box((double)0.0, (double)0.5, (double)0.0, (double)0.5, (double)1.0, (double)1.0)),
    DOWN(dir -> Direction.DOWN, Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0), Shapes.box((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0)),
    RIGHT(Direction::getClockWise, Shapes.box((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), Shapes.box((double)0.5, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)1.0)),
    LEFT(Direction::getCounterClockWise, Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0), Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)0.5, (double)1.0));

    private final String name = this.toString().toLowerCase(Locale.ROOT);
    private final Function<Direction, Direction> facingMod;
    private final VoxelShape slabShape;
    private final VoxelShape cornerShape;

    private HorizontalRotation(Function<Direction, Direction> facingMod, VoxelShape slabShape, VoxelShape cornerShape) {
        this.facingMod = facingMod;
        this.slabShape = slabShape;
        this.cornerShape = cornerShape;
    }

    public Direction withFacing(Direction dir) {
        return this.facingMod.apply(dir);
    }

    public HorizontalRotation getOpposite() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> DOWN;
            case 1 -> UP;
            case 2 -> LEFT;
            case 3 -> RIGHT;
        };
    }

    public HorizontalRotation rotate(Rotation rot) {
        return switch (rot) {
            default -> throw new MatchException(null, null);
            case Rotation.NONE -> this;
            case Rotation.CLOCKWISE_180 -> this.getOpposite();
            case Rotation.CLOCKWISE_90 -> {
                switch (this.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield RIGHT;
                    }
                    case 1: {
                        yield LEFT;
                    }
                    case 2: {
                        yield DOWN;
                    }
                    case 3: 
                }
                yield UP;
            }
            case Rotation.COUNTERCLOCKWISE_90 -> {
                switch (this.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield LEFT;
                    }
                    case 1: {
                        yield RIGHT;
                    }
                    case 2: {
                        yield UP;
                    }
                    case 3: 
                }
                yield DOWN;
            }
        };
    }

    public boolean isVertical() {
        return this == UP || this == DOWN;
    }

    public boolean isSameDir(Direction dir, HorizontalRotation adjRot, Direction adjDir) {
        return this.withFacing(dir) == adjRot.withFacing(adjDir);
    }

    public VoxelShape getSlabShape() {
        return this.slabShape;
    }

    public VoxelShape getCornerShape() {
        return this.cornerShape;
    }

    public String getSerializedName() {
        return this.name;
    }

    public static HorizontalRotation fromDirection(Direction facing, Direction dir) {
        Preconditions.checkArgument((!Utils.isY(facing) ? 1 : 0) != 0, (Object)"View direction must not be on the Y axis");
        Preconditions.checkArgument((facing.getAxis() != dir.getAxis() ? 1 : 0) != 0, (Object)"Directions must be perpendicular");
        if (dir == Direction.UP) {
            return UP;
        }
        if (dir == Direction.DOWN) {
            return DOWN;
        }
        if (dir == facing.getClockWise()) {
            return RIGHT;
        }
        if (dir == facing.getCounterClockWise()) {
            return LEFT;
        }
        throw new IllegalStateException(String.format("How did we get here?! %s|%s", facing, dir));
    }

    public static HorizontalRotation fromDirection(Direction facing, Direction dir, Vec3 hitVec) {
        HorizontalRotation rot = HorizontalRotation.fromDirection(facing, dir);
        double dist = switch (rot.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Utils.fractionInDir(hitVec, facing.getCounterClockWise());
            case 1 -> Utils.fractionInDir(hitVec, facing.getClockWise());
            case 2 -> Utils.fractionInDir(hitVec, Direction.UP);
            case 3 -> Utils.fractionInDir(hitVec, Direction.DOWN);
        };
        return dist > 0.5 ? rot.rotate(Rotation.CLOCKWISE_90) : rot;
    }

    public static HorizontalRotation fromWallCross(Vec3 hitVec, Direction hitFace) {
        hitVec = Utils.fraction(hitVec);
        double xz = (Utils.isX(hitFace) ? hitVec.z() : hitVec.x()) - 0.5;
        double y = hitVec.y() - 0.5;
        if (Math.max(Math.abs(xz), Math.abs(y)) == Math.abs(xz)) {
            if (Utils.isX(hitFace)) {
                return xz < 0.0 == Utils.isPositive(hitFace) ? LEFT : RIGHT;
            }
            return xz < 0.0 == Utils.isPositive(hitFace) ? RIGHT : LEFT;
        }
        return y < 0.0 ? UP : DOWN;
    }

    public static HorizontalRotation fromWallCorner(Vec3 hitVec, Direction hitFace) {
        double xz;
        Preconditions.checkArgument((!Utils.isY(hitFace) ? 1 : 0) != 0, (Object)"Hit face must not be on the Y axis");
        hitVec = Utils.fraction(hitVec);
        double d = xz = Utils.isX(hitFace) ? hitVec.z() : hitVec.x();
        if (!Utils.isPositive(hitFace.getCounterClockWise())) {
            xz = 1.0 - xz;
        }
        if (hitVec.y() > 0.5) {
            return xz > 0.5 ? LEFT : DOWN;
        }
        return xz > 0.5 ? UP : RIGHT;
    }

    public static HorizontalRotation fromPerpendicularWallCorner(Direction facing, Direction hitFace, Vec3 hitVec) {
        Preconditions.checkArgument((!Utils.isY(facing) ? 1 : 0) != 0, (Object)"View direction must not be on the Y axis");
        Preconditions.checkArgument((facing.getAxis() != hitFace.getAxis() ? 1 : 0) != 0, (Object)"Directions must be perpendicular");
        if (hitFace == Direction.UP) {
            if (Utils.fractionInDir(hitVec, facing.getCounterClockWise()) > 0.5) {
                return RIGHT;
            }
            return UP;
        }
        if (hitFace == Direction.DOWN) {
            if (Utils.fractionInDir(hitVec, facing.getClockWise()) > 0.5) {
                return LEFT;
            }
            return DOWN;
        }
        if (hitFace == facing.getClockWise()) {
            if (Utils.fractionInDir(hitVec, Direction.UP) > 0.5) {
                return DOWN;
            }
            return RIGHT;
        }
        if (hitFace == facing.getCounterClockWise()) {
            if (Utils.fractionInDir(hitVec, Direction.DOWN) > 0.5) {
                return UP;
            }
            return LEFT;
        }
        throw new IllegalStateException(String.format("How did we get here?! %s|%s", facing, hitFace));
    }
}

