/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.cube;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedTankBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedTankBlock
extends FramedBlock {
    public static final String TANK_CONTENTS = Utils.translationKey("desc", "block.fluid_tank.contents");
    public static final Component EMPTY_FLUID = Utils.translate("desc", "block.fluid_tank.contents.empty").withStyle(ChatFormatting.ITALIC);

    public FramedTankBlock() {
        super(BlockType.FRAMED_TANK);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.SOLID});
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemInteractionResult result = super.useItemOn(stack, state, level, pos, player, hand, hit);
        if (result.consumesAction() && result != ItemInteractionResult.CONSUME_PARTIAL) {
            return result;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedTankBlockEntity) {
            FramedTankBlockEntity be = (FramedTankBlockEntity)blockEntity;
            return be.handleTankInteraction(player, hand);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedTankBlockEntity) {
            FramedTankBlockEntity be = (FramedTankBlockEntity)blockEntity;
            return be.getAnalogSignal();
        }
        return 0;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedTankBlockEntity(pos, state);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> lines, TooltipFlag flag) {
        super.appendHoverText(stack, ctx, lines, flag);
        Component name = EMPTY_FLUID;
        SimpleFluidContent content = (SimpleFluidContent)stack.getOrDefault(FBContent.DC_TYPE_TANK_CONTENTS, (Object)SimpleFluidContent.EMPTY);
        if (!content.isEmpty()) {
            name = content.getFluid().getFluidType().getDescription().copy().withStyle(ChatFormatting.WHITE);
        }
        lines.add((Component)Component.translatable((String)TANK_CONTENTS, (Object[])new Object[]{name}).withStyle(ChatFormatting.GOLD));
    }

    @Override
    public BlockState getItemModelSource() {
        return this.defaultBlockState();
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.defaultBlockState();
    }
}

