/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.common.NeoForge;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.render.debug.AttachDebugRenderersEvent;
import xfacthd.framedblocks.api.render.debug.BlockDebugRenderer;
import xfacthd.framedblocks.common.config.DevToolsConfig;

public final class FramedBlockDebugRenderer {
    private static final Map<BlockEntityType<? extends FramedBlockEntity>, Set<BlockDebugRenderer<? extends FramedBlockEntity>>> RENDERERS_BY_TYPE = new IdentityHashMap<BlockEntityType<? extends FramedBlockEntity>, Set<BlockDebugRenderer<? extends FramedBlockEntity>>>();

    public static void render(DeltaTracker delta, Camera camera, PoseStack poseStack) {
        HitResult hit = Minecraft.getInstance().hitResult;
        if (!(hit instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHit = (BlockHitResult)hit;
        ClientLevel level = Objects.requireNonNull(Minecraft.getInstance().level);
        BlockPos pos = blockHit.getBlockPos();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof FramedBlockEntity)) {
            return;
        }
        FramedBlockEntity be = (FramedBlockEntity)blockEntity;
        Set<BlockDebugRenderer<? extends FramedBlockEntity>> renderers = RENDERERS_BY_TYPE.get(be.getType());
        if (renderers.isEmpty()) {
            return;
        }
        Vec3 offset = Vec3.atLowerCornerOf((Vec3i)pos).subtract(camera.getPosition());
        poseStack.pushPose();
        poseStack.translate(offset.x, offset.y, offset.z);
        float partialTick = delta.getGameTimeDeltaPartialTick(false);
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        for (BlockDebugRenderer<? extends FramedBlockEntity> renderer : renderers) {
            if (!renderer.isEnabled()) continue;
            poseStack.pushPose();
            renderer.render(be, blockHit, partialTick, poseStack, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
        poseStack.popPose();
        buffer.endBatch();
    }

    private static void onRenderFramePre(RenderFrameEvent.Pre event) {
        if (DevToolsConfig.VIEW.isDoubleBlockPartHitDebugRendererEnabled()) {
            Minecraft.getInstance().levelRenderer.requestOutlineEffect();
        }
    }

    public static void init() {
        if (FMLEnvironment.production) {
            return;
        }
        ModLoader.postEvent((Event)new AttachDebugRenderersEvent((type, renderer) -> RENDERERS_BY_TYPE.computeIfAbsent((BlockEntityType<? extends FramedBlockEntity>)type, $ -> new ReferenceOpenHashSet()).add(renderer)));
        NeoForge.EVENT_BUS.addListener(FramedBlockDebugRenderer::onRenderFramePre);
    }

    private FramedBlockDebugRenderer() {
    }
}

