/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopepanel;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.slopepanel.FramedSlopePanelGeometry;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedExtendedSlopePanelGeometry
extends Geometry {
    private final Direction facing;
    private final HorizontalRotation rotation;
    private final Direction orientation;
    private final boolean ySlope;

    public FramedExtendedSlopePanelGeometry(GeometryFactory.Context ctx) {
        this.facing = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.rotation = (HorizontalRotation)((Object)ctx.state().getValue(PropertyHolder.ROTATION));
        this.orientation = this.rotation.withFacing(this.facing);
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction face = quad.getDirection();
        boolean yAxis = Utils.isY(this.orientation);
        if (face == this.orientation) {
            if (Utils.isY(this.orientation)) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing.getOpposite(), 0.5f)).export(quadMap.get(face));
                if (this.ySlope) {
                    QuadModifier.of(quad).apply(FramedSlopePanelGeometry.createVerticalSlope(this.facing, this.orientation)).apply(Modifiers.offset(this.facing.getOpposite(), 0.5f)).export(quadMap.get(null));
                }
            } else {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.facing.getOpposite(), 0.5f)).export(quadMap.get(face));
            }
        } else if (!(this.rotation.isVertical() && this.ySlope || face != this.facing.getOpposite())) {
            QuadModifier.of(quad).apply(FramedSlopePanelGeometry.createSlope(this.facing, this.orientation)).export(quadMap.get(null));
        } else if (face.getAxis() != this.facing.getAxis() && face.getAxis() != this.orientation.getAxis()) {
            if (yAxis) {
                boolean up = this.orientation == Direction.UP;
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.facing.getOpposite(), up ? 0.5f : 1.0f, up ? 1.0f : 0.5f)).export(quadMap.get(face));
            } else {
                boolean rightRot = this.rotation == HorizontalRotation.RIGHT;
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing.getOpposite(), rightRot ? 1.0f : 0.5f, rightRot ? 0.5f : 1.0f)).export(quadMap.get(face));
            }
        }
    }
}

