/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.interactive;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedPressurePlateGeometry
extends Geometry {
    private final boolean pressed;
    private final boolean useBaseModel;

    public FramedPressurePlateGeometry(GeometryFactory.Context ctx) {
        this((Boolean)ctx.state().getValue((Property)BlockStateProperties.POWERED), false);
    }

    protected FramedPressurePlateGeometry(boolean powered, boolean useBaseModel) {
        this.pressed = powered;
        this.useBaseModel = useBaseModel;
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        float height;
        Direction quadDir = quad.getDirection();
        float f = height = this.pressed ? 0.03125f : 0.0625f;
        if (Utils.isY(quadDir)) {
            boolean up = quadDir == Direction.UP;
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.0625f, 0.0625f, 0.9375f, 0.9375f)).applyIf(Modifiers.setPosition(height), up).export(quadMap.get(up ? null : Direction.DOWN));
        } else {
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.0625f, 0.0f, 0.9375f, height)).apply(Modifiers.setPosition(0.9375f)).export(quadMap.get(null));
        }
    }

    @Override
    public boolean useBaseModel() {
        return this.useBaseModel;
    }
}

