/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.inventories.InternalInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.interfaces.IProgressProvider;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.OutputSlot;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.common.tileentities.TileCircuitCutter;
import com.glodblock.github.extendedae.container.helper.DirectionSet;
import com.glodblock.github.glodium.network.packet.sync.ActionMap;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;

public class ContainerCircuitCutter
extends UpgradeableMenu<TileCircuitCutter>
implements IProgressProvider,
IActionHolder {
    @GuiSync(value=3)
    public int processingTime = -1;
    @GuiSync(value=8)
    public YesNo autoExport = YesNo.NO;
    @GuiSync(value=9)
    public DirectionSet outputSides = new DirectionSet(new ArrayList<Direction>());
    private final ActionMap actions = ActionMap.create();
    public static final MenuType<ContainerCircuitCutter> TYPE = MenuTypeBuilder.create(ContainerCircuitCutter::new, TileCircuitCutter.class).buildUnregistered(ExtendedAE.id("circuit_cutter"));

    public ContainerCircuitCutter(int id, Inventory ip, TileCircuitCutter host) {
        super(TYPE, id, ip, (IUpgradeableObject)host);
        this.addSlot((Slot)new AppEngSlot((InternalInventory)host.getInput(), 0), SlotSemantics.MACHINE_INPUT);
        this.addSlot((Slot)new OutputSlot((InternalInventory)host.getOutput(), 0, null), SlotSemantics.MACHINE_OUTPUT);
        this.actions.put("set_side", o -> this.setOutputSide((String)o.get(0), (Boolean)o.get(1)));
    }

    private void setOutputSide(String name, boolean value) {
        Direction side = Direction.byName((String)name);
        if (value) {
            ((TileCircuitCutter)this.getHost()).getOutputSides().add(side);
        } else {
            ((TileCircuitCutter)this.getHost()).getOutputSides().remove(side);
        }
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.autoExport = (YesNo)cm.getSetting(Settings.AUTO_EXPORT);
        this.outputSides.clear();
        this.outputSides.addAll(((TileCircuitCutter)this.getHost()).getOutputSides());
    }

    protected void standardDetectAndSendChanges() {
        if (this.isServerSide()) {
            this.processingTime = ((TileCircuitCutter)this.getHost()).getProgress();
        }
        super.standardDetectAndSendChanges();
    }

    public int getCurrentProgress() {
        return this.processingTime;
    }

    public int getMaxProgress() {
        return 200;
    }

    public YesNo getAutoExport() {
        return this.autoExport;
    }

    public List<Direction> getOutputSides() {
        return this.outputSides.sides();
    }

    @NotNull
    public ActionMap getActionMap() {
        return this.actions;
    }
}

