/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.parts;

import appeng.api.behaviors.PlacementStrategy;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigManagerBuilder;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.helpers.IConfigInvHost;
import appeng.helpers.IPriorityHost;
import appeng.helpers.MultiCraftingTracker;
import appeng.items.parts.PartModels;
import appeng.me.helpers.MachineSource;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.parts.automation.PlaneConnectionHelper;
import appeng.parts.automation.PlaneConnections;
import appeng.parts.automation.PlaneModelData;
import appeng.parts.automation.PlaneModels;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.parts.automation.UpgradeablePart;
import appeng.util.ConfigInventory;
import appeng.util.Platform;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.container.ContainerActiveFormationPlane;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class PartActiveFormationPlane
extends UpgradeablePart
implements IGridTickable,
IPriorityHost,
IConfigInvHost,
ICraftingRequester {
    public static final List<ResourceLocation> MODELS = List.of(ExtendedAE.id("part/active_formation_plane"), ExtendedAE.id("part/active_formation_plane_on"));
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODELS.get(0), PlaneModels.MODEL_CHASSIS_OFF});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODELS.get(0), PlaneModels.MODEL_CHASSIS_ON});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODELS.get(1), PlaneModels.MODEL_CHASSIS_HAS_CHANNEL});
    private boolean wasOnline = false;
    private int priority = 0;
    private final PlaneConnectionHelper connectionHelper = new PlaneConnectionHelper((AEBasePart)this);
    private final ConfigInventory config;
    @Nullable
    private PlacementStrategy placementStrategies;
    private final MultiCraftingTracker craftingTracker;
    protected final IActionSource source;

    public PartActiveFormationPlane(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().addService(IGridTickable.class, (IGridNodeService)this).addService(ICraftingRequester.class, (IGridNodeService)this);
        this.config = ConfigInventory.configTypes((int)63).supportedTypes((Collection)StackWorldBehaviors.withPlacementStrategy()).build();
        this.source = new MachineSource((IActionHost)this);
        this.craftingTracker = new MultiCraftingTracker((ICraftingRequester)this, this.config.size());
    }

    protected void registerSettings(IConfigManagerBuilder builder) {
        super.registerSettings(builder);
        builder.registerSetting(Settings.PLACE_BLOCK, (Enum)YesNo.YES);
        builder.registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        builder.registerSetting(Settings.CRAFT_ONLY, (Enum)YesNo.NO);
    }

    protected final PlacementStrategy getPlacementStrategies() {
        if (this.placementStrategies == null) {
            IGridNode node = this.getMainNode().getNode();
            if (node == null) {
                return PlacementStrategy.noop();
            }
            BlockEntity self = this.getHost().getBlockEntity();
            BlockPos pos = self.getBlockPos().relative(this.getSide());
            Direction side = this.getSide().getOpposite();
            UUID owningPlayerId = this.getMainNode().getNode().getOwningPlayerProfileId();
            this.placementStrategies = StackWorldBehaviors.createPlacementStrategies((ServerLevel)((ServerLevel)self.getLevel()), (BlockPos)pos, (Direction)side, (BlockEntity)self, (UUID)owningPlayerId);
        }
        return this.placementStrategies;
    }

    protected int getUpgradeSlots() {
        return 5;
    }

    public void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        this.getHost().markForSave();
    }

    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        boolean currentOnline = this.getMainNode().isOnline();
        if (this.wasOnline != currentOnline) {
            this.wasOnline = currentOnline;
            this.getHost().markForUpdate();
        }
    }

    public void getBoxes(IPartCollisionHelper bch) {
        this.connectionHelper.getBoxes(bch);
    }

    public PlaneConnections getConnections() {
        return this.connectionHelper.getConnections();
    }

    public void onNeighborChanged(BlockGetter level, BlockPos pos, BlockPos neighbor) {
        if (pos.relative(this.getSide()).equals((Object)neighbor)) {
            if (!this.isClientSide()) {
                this.getPlacementStrategies().clearBlocked();
            }
        } else {
            this.connectionHelper.updateConnections();
        }
    }

    public void onUpdateShape(Direction side) {
        Direction ourSide = this.getSide();
        if (side.equals((Object)ourSide)) {
            if (!this.isClientSide()) {
                this.getPlacementStrategies().clearBlocked();
            }
        } else if (ourSide.getAxis() != side.getAxis()) {
            this.connectionHelper.updateConnections();
        }
    }

    protected long placeInWorld(AEKey what, long amount) {
        YesNo placeBlock = (YesNo)this.getConfigManager().getSetting(Settings.PLACE_BLOCK);
        return this.getPlacementStrategies().placeInWorld(what, amount, Actionable.MODULATE, placeBlock != YesNo.YES);
    }

    protected long placeInWorld(AEKey what, long amount, Actionable mode) {
        YesNo placeBlock = (YesNo)this.getConfigManager().getSetting(Settings.PLACE_BLOCK);
        return this.getPlacementStrategies().placeInWorld(what, amount, mode, placeBlock != YesNo.YES);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    public void readFromNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.readFromNBT(data, registries);
        this.priority = data.getInt("priority");
        this.config.readFromChildTag(data, "config", registries);
        this.craftingTracker.readFromNBT(data);
    }

    public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.writeToNBT(data, registries);
        data.putInt("priority", this.getPriority());
        this.config.writeToChildTag(data, "config", registries);
        this.craftingTracker.writeToNBT(data);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
    }

    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        MenuOpener.returnTo(this.getMenuType(), (Player)player, (MenuHostLocator)MenuLocators.forPart((AEBasePart)this));
    }

    public ItemStack getMainMenuIcon() {
        return new ItemStack((ItemLike)this.getPartItem());
    }

    private void openConfigMenu(Player player) {
        MenuOpener.open(this.getMenuType(), (Player)player, (MenuHostLocator)MenuLocators.forPart((AEBasePart)this));
    }

    protected MenuType<?> getMenuType() {
        return ContainerActiveFormationPlane.TYPE;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.ExportBus.getMin(), TickRates.ExportBus.getMax(), this.isSleeping());
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.isSleeping()) {
            return TickRateModulation.SLEEP;
        }
        if (!this.canWork()) {
            return TickRateModulation.IDLE;
        }
        boolean hasDoneWork = this.doWork(node.getGrid());
        return hasDoneWork ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    protected final boolean canWork() {
        if (!this.getMainNode().isActive()) {
            return false;
        }
        BlockEntity self = this.getHost().getBlockEntity();
        BlockPos targetPos = self.getBlockPos().relative(this.getSide());
        if (self.getLevel() == null) {
            return false;
        }
        if (this.getConfigManager().getSetting(Settings.PLACE_BLOCK) == YesNo.YES) {
            BlockState block = self.getLevel().getBlockState(targetPos);
            return block.canBeReplaced();
        }
        return Platform.areBlockEntitiesTicking((Level)self.getLevel(), (BlockPos)targetPos);
    }

    protected int availableSlots() {
        return Math.min(18 + this.getInstalledUpgrades((ItemLike)AEItems.CAPACITY_CARD) * 9, this.getConfig().size());
    }

    protected boolean doWork(IGrid grid) {
        IStorageService storageService = grid.getStorageService();
        FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
        ICraftingService cg = grid.getCraftingService();
        for (int x = 0; x < this.availableSlots(); ++x) {
            AEKey what = this.getConfig().getKey(x);
            if (what == null) continue;
            if (this.craftOnly()) {
                this.attemptCrafting(cg, x, what);
                continue;
            }
            if (this.isUpgradedWith((ItemLike)AEItems.FUZZY_CARD)) {
                for (Object2LongMap.Entry fuzzyWhat : ImmutableList.copyOf((Collection)storageService.getCachedInventory().findFuzzy(what, fzMode))) {
                    if (!this.isSuccess(storageService, (AEKey)fuzzyWhat.getKey())) continue;
                    return true;
                }
            } else if (this.isSuccess(storageService, what)) {
                return true;
            }
            if (!this.isCraftingEnabled()) continue;
            this.attemptCrafting(cg, x, what);
        }
        return false;
    }

    private boolean isSuccess(IStorageService storageService, AEKey what) {
        long toExt = storageService.getInventory().extract(what, (long)what.getAmountPerUnit(), Actionable.MODULATE, IActionSource.ofMachine((IActionHost)this));
        if (toExt > 0L) {
            long res = this.placeInWorld(what, toExt);
            long differ = toExt - res;
            if (differ > 0L) {
                storageService.getInventory().insert(what, differ, Actionable.MODULATE, IActionSource.ofMachine((IActionHost)this));
            }
            return res > 0L;
        }
        return false;
    }

    public boolean onUseWithoutItem(Player player, Vec3 pos) {
        if (!this.isClientSide()) {
            this.openConfigMenu(player);
        }
        return true;
    }

    public ConfigInventory getConfig() {
        return this.config;
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    public ModelData getModelData() {
        return ModelData.builder().with(PlaneModelData.CONNECTIONS, (Object)this.getConnections()).build();
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.craftingTracker.getRequestedJobs();
    }

    public long insertCraftedItems(ICraftingLink link, AEKey what, long amount, Actionable mode) {
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null && this.getMainNode().isActive()) {
            return this.placeInWorld(what, amount, mode);
        }
        return 0L;
    }

    public void jobStateChange(ICraftingLink link) {
        this.craftingTracker.jobStateChange(link);
    }

    private void attemptCrafting(ICraftingService cg, int slotToExport, AEKey what) {
        long amount = this.placeInWorld(what, what.getAmountPerUnit(), Actionable.SIMULATE);
        if (amount > 0L) {
            this.requestCrafting(cg, slotToExport, what, amount);
        }
    }

    protected final void requestCrafting(ICraftingService cg, int configSlot, AEKey what, long amount) {
        this.craftingTracker.handleCrafting(configSlot, what, amount, this.getBlockEntity().getLevel(), cg, this.source);
    }

    private boolean craftOnly() {
        return this.isCraftingEnabled() && this.getConfigManager().getSetting(Settings.CRAFT_ONLY) == YesNo.YES;
    }

    private boolean isCraftingEnabled() {
        return this.isUpgradedWith((ItemLike)AEItems.CRAFTING_CARD);
    }
}

