/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import fuzs.eternalnether.init.ModEntityTypes;
import fuzs.eternalnether.services.CommonAbstractions;
import fuzs.eternalnether.world.entity.ai.behavior.ModFollowLeader;
import fuzs.eternalnether.world.entity.ai.behavior.ModStartAdmiringItemIfSeen;
import fuzs.eternalnether.world.entity.ai.behavior.ModStopAdmiringIfItemTooFarAway;
import fuzs.eternalnether.world.entity.ai.behavior.ModStopAdmiringIfTiredOfTryingToReachItem;
import fuzs.eternalnether.world.entity.ai.behavior.ModStopHoldingItemIfNoLongerAdmiring;
import fuzs.eternalnether.world.entity.monster.piglin.PiglinPrisoner;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BackUpIfTooClose;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CopyMemoryWithExpiry;
import net.minecraft.world.entity.ai.behavior.CrossbowAttack;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.GoToTargetLocation;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.InteractWith;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;

public class PiglinPrisonerAi
extends PiglinAi {
    private static final UniformInt AVOID_ZOMBIFIED_DURATION = TimeUtil.rangeOfSeconds((int)5, (int)7);
    private static final int CELEBRATION_TIME = 200;
    private static final Predicate<PathfinderMob> isDistracted = mob -> {
        if (mob instanceof PiglinPrisoner) {
            PiglinPrisoner piglinPrisoner = (PiglinPrisoner)((Object)mob);
            Brain<PiglinPrisoner> brain = piglinPrisoner.getBrain();
            return brain.hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM) || brain.hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_NEMESIS) || brain.hasMemoryValue(MemoryModuleType.AVOID_TARGET) || brain.getMemory(MemoryModuleType.DANCING).orElse(false) != false || brain.getMemory(MemoryModuleType.IS_TEMPTED).orElse(false) == false;
        }
        return false;
    };

    public static Brain<?> makeBrain(PiglinPrisoner piglinPrisoner, Brain<PiglinPrisoner> brain) {
        PiglinPrisonerAi.initCoreActivity(brain);
        PiglinPrisonerAi.initIdleActivity(brain);
        PiglinPrisonerAi.initAdmireItemActivity(brain);
        PiglinPrisonerAi.initFightActivity(piglinPrisoner, brain);
        PiglinPrisonerAi.initCelebrateActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<PiglinPrisoner> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)((Object)new ModFollowLeader(isDistracted)), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)InteractWithDoor.create(), PiglinPrisonerAi.avoidZombified(), new ModStopHoldingItemIfNoLongerAdmiring(), new ModStartAdmiringItemIfSeen(120), (Object)StopBeingAngryIfTargetDead.create()));
    }

    private static void initIdleActivity(Brain<PiglinPrisoner> brain) {
        brain.addActivity(Activity.IDLE, 10, ImmutableList.of((Object)SetEntityLookTarget.create(PiglinPrisonerAi::isPlayerHoldingLovedItem, (float)14.0f), (Object)StartAttacking.create(AbstractPiglin::isAdult, PiglinPrisonerAi::findNearestValidAttackTarget), PiglinPrisonerAi.avoidRepellent(), PiglinPrisonerAi.createIdleLookBehaviors(), PiglinPrisonerAi.createIdleMovementBehaviors(), (Object)SetLookAndInteract.create((EntityType)EntityType.PLAYER, (int)4)));
    }

    private static void initFightActivity(PiglinPrisoner piglinPrisoner, Brain<PiglinPrisoner> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of((Object)StopAttackingIfTargetInvalid.create(target -> !PiglinPrisonerAi.isNearestValidAttackTarget(piglinPrisoner, target)), (Object)BehaviorBuilder.triggerIf(PiglinPrisonerAi::hasCrossbow, (OneShot)BackUpIfTooClose.create((int)5, (float)0.75f)), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.0f), (Object)MeleeAttack.create((int)20), (Object)new CrossbowAttack(), (Object)EraseMemoryIf.create(PiglinPrisonerAi::isNearZombified, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET)), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initCelebrateActivity(Brain<PiglinPrisoner> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.CELEBRATE, 10, ImmutableList.of(PiglinPrisonerAi.avoidRepellent(), (Object)SetEntityLookTarget.create(PiglinPrisonerAi::isPlayerHoldingLovedItem, (float)14.0f), (Object)StartAttacking.create(AbstractPiglin::isAdult, PiglinPrisonerAi::findNearestValidAttackTarget), (Object)BehaviorBuilder.triggerIf(PiglinPrisoner::isDancing, (OneShot)GoToTargetLocation.create((MemoryModuleType)MemoryModuleType.CELEBRATE_LOCATION, (int)2, (float)1.0f)), (Object)BehaviorBuilder.triggerIf(PiglinPrisoner::isDancing, (OneShot)GoToTargetLocation.create((MemoryModuleType)MemoryModuleType.CELEBRATE_LOCATION, (int)4, (float)0.6f)), (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)((EntityType)ModEntityTypes.PIGLIN_PRISONER.value()), (float)8.0f), (Object)1), (Object)Pair.of((Object)RandomStroll.stroll((float)0.6f, (int)2, (int)1), (Object)1), (Object)Pair.of((Object)new DoNothing(10, 20), (Object)1)))), MemoryModuleType.CELEBRATE_LOCATION);
    }

    private static void initAdmireItemActivity(Brain<PiglinPrisoner> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.ADMIRE_ITEM, 10, ImmutableList.of((Object)GoToWantedItem.create(PiglinPrisonerAi::isNotHoldingLovedItemInOffHand, (float)1.0f, (boolean)true, (int)9), new ModStopAdmiringIfItemTooFarAway(9), new ModStopAdmiringIfTiredOfTryingToReachItem(200, 200)), MemoryModuleType.ADMIRING_ITEM);
    }

    private static RunOne<LivingEntity> createIdleLookBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.PLAYER, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.PIGLIN, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)((EntityType)ModEntityTypes.PIGLIN_PRISONER.value()), (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((float)8.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static RunOne<PiglinPrisoner> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)0.6f), (Object)2), (Object)Pair.of((Object)InteractWith.of((EntityType)EntityType.PIGLIN, (int)8, (MemoryModuleType)MemoryModuleType.INTERACTION_TARGET, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)InteractWith.of((EntityType)((EntityType)ModEntityTypes.PIGLIN_PRISONER.value()), (int)8, (MemoryModuleType)MemoryModuleType.INTERACTION_TARGET, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static BehaviorControl<PathfinderMob> avoidRepellent() {
        return SetWalkTargetAwayFrom.pos((MemoryModuleType)MemoryModuleType.NEAREST_REPELLENT, (float)1.0f, (int)8, (boolean)false);
    }

    private static BehaviorControl<PiglinPrisoner> avoidZombified() {
        return CopyMemoryWithExpiry.create(PiglinPrisonerAi::isNearZombified, (MemoryModuleType)MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED, (MemoryModuleType)MemoryModuleType.AVOID_TARGET, (UniformInt)AVOID_ZOMBIFIED_DURATION);
    }

    public static void updateActivity(PiglinPrisoner piglinPrisoner) {
        Brain<PiglinPrisoner> brain = piglinPrisoner.getBrain();
        Activity activity = brain.getActiveNonCoreActivity().orElse(null);
        brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.ADMIRE_ITEM, (Object)Activity.FIGHT, (Object)Activity.AVOID, (Object)Activity.CELEBRATE, (Object)Activity.IDLE));
        Activity activity1 = brain.getActiveNonCoreActivity().orElse(null);
        if (activity != activity1) {
            PiglinPrisonerAi.getSoundForCurrentActivity(piglinPrisoner).ifPresent(piglinPrisoner::playSound);
        }
        piglinPrisoner.setAggressive(brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
        if (!brain.hasMemoryValue(MemoryModuleType.CELEBRATE_LOCATION)) {
            brain.eraseMemory(MemoryModuleType.DANCING);
        }
        piglinPrisoner.setDancing(brain.hasMemoryValue(MemoryModuleType.DANCING));
    }

    public static void pickUpItem(PiglinPrisoner piglinPrisoner, ItemEntity itemEntity) {
        ItemStack itemstack;
        PiglinPrisonerAi.stopWalking(piglinPrisoner);
        if (itemEntity.getItem().is(Items.GOLD_NUGGET)) {
            piglinPrisoner.take((Entity)itemEntity, itemEntity.getItem().getCount());
            itemstack = itemEntity.getItem();
            itemEntity.discard();
        } else {
            piglinPrisoner.take((Entity)itemEntity, 1);
            itemstack = PiglinPrisonerAi.removeOneItemFromItemEntity(itemEntity);
        }
        if (PiglinPrisonerAi.isLovedItem(itemstack)) {
            piglinPrisoner.getBrain().eraseMemory(MemoryModuleType.TIME_TRYING_TO_REACH_ADMIRE_ITEM);
            PiglinPrisonerAi.holdInOffhand(piglinPrisoner, itemstack);
            PiglinPrisonerAi.admireGoldItem(piglinPrisoner);
        } else if (PiglinPrisonerAi.isFood(itemstack) && !PiglinPrisonerAi.hasEatenRecently(piglinPrisoner)) {
            PiglinPrisonerAi.eat(piglinPrisoner);
        } else if (piglinPrisoner.equipItemIfPossible(itemstack).isEmpty()) {
            PiglinPrisonerAi.putInInventory(piglinPrisoner, itemstack);
        }
    }

    public static void holdInOffhand(PiglinPrisoner piglinPrisoner, ItemStack stack) {
        if (PiglinPrisonerAi.isHoldingItemInOffHand(piglinPrisoner)) {
            piglinPrisoner.spawnAtLocation(piglinPrisoner.getItemInHand(InteractionHand.OFF_HAND));
        }
        piglinPrisoner.holdInOffHand(stack);
    }

    private static ItemStack removeOneItemFromItemEntity(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.getItem();
        ItemStack itemstack1 = itemstack.split(1);
        if (itemstack.isEmpty()) {
            itemEntity.discard();
        } else {
            itemEntity.setItem(itemstack);
        }
        return itemstack1;
    }

    public static void stopHoldingOffHandItem(PiglinPrisoner piglinPrisoner, boolean shouldThrowItems) {
        ItemStack itemstack = piglinPrisoner.getItemInHand(InteractionHand.OFF_HAND);
        piglinPrisoner.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
        boolean isPiglinCurrency = CommonAbstractions.INSTANCE.isPiglinCurrency(itemstack);
        if (shouldThrowItems && isPiglinCurrency) {
            PiglinPrisonerAi.putInInventory(piglinPrisoner, itemstack);
        } else if (!isPiglinCurrency) {
            boolean flag1;
            boolean bl = flag1 = !piglinPrisoner.equipItemIfPossible(itemstack).isEmpty();
            if (!flag1) {
                PiglinPrisonerAi.throwItems(piglinPrisoner, Collections.singletonList(itemstack));
            }
        }
    }

    public static void throwItems(PiglinPrisoner piglinPrisoner, List<ItemStack> stackList) {
        Player tempter = piglinPrisoner.getTempter();
        Optional optional = piglinPrisoner.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER);
        if (tempter != null) {
            PiglinPrisonerAi.throwItemsTowardPlayer(piglinPrisoner, tempter, stackList);
        } else if (optional.isPresent()) {
            PiglinPrisonerAi.throwItemsTowardPlayer(piglinPrisoner, (Player)optional.get(), stackList);
        } else {
            PiglinPrisonerAi.throwItemsTowardRandomPos(piglinPrisoner, stackList);
        }
    }

    private static void throwItemsTowardRandomPos(PiglinPrisoner piglinPrisoner, List<ItemStack> stackList) {
        PiglinPrisonerAi.throwItemsTowardPos(piglinPrisoner, stackList, PiglinPrisonerAi.getRandomNearbyPos(piglinPrisoner));
    }

    private static void throwItemsTowardPlayer(PiglinPrisoner piglinPrisoner, Player player, List<ItemStack> stackList) {
        PiglinPrisonerAi.throwItemsTowardPos(piglinPrisoner, stackList, player.position());
    }

    private static void throwItemsTowardPos(PiglinPrisoner piglinPrisoner, List<ItemStack> stackList, Vec3 vec) {
        if (!stackList.isEmpty()) {
            piglinPrisoner.swing(InteractionHand.OFF_HAND);
            for (ItemStack itemstack : stackList) {
                BehaviorUtils.throwItem((LivingEntity)piglinPrisoner, (ItemStack)itemstack, (Vec3)vec.add(0.0, 1.0, 0.0));
            }
        }
    }

    private static Vec3 getRandomNearbyPos(PiglinPrisoner piglinPrisoner) {
        Vec3 vec3 = LandRandomPos.getPos((PathfinderMob)piglinPrisoner, (int)4, (int)2);
        return vec3 == null ? piglinPrisoner.position() : vec3;
    }

    public static void cancelAdmiring(PiglinPrisoner piglinPrisoner) {
        if (PiglinPrisonerAi.isAdmiringItem(piglinPrisoner) && !piglinPrisoner.getOffhandItem().isEmpty()) {
            piglinPrisoner.spawnAtLocation(piglinPrisoner.getOffhandItem());
            piglinPrisoner.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
        }
    }

    public static boolean wantsToPickup(PiglinPrisoner piglinPrisoner, ItemStack itemStack) {
        if (itemStack.is(ItemTags.PIGLIN_REPELLENTS)) {
            return false;
        }
        if (PiglinPrisonerAi.isAdmiringDisabled(piglinPrisoner) && piglinPrisoner.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
            return false;
        }
        if (CommonAbstractions.INSTANCE.isPiglinCurrency(itemStack) || PiglinPrisonerAi.isLovedItem(itemStack)) {
            return PiglinPrisonerAi.isNotHoldingLovedItemInOffHand(piglinPrisoner);
        }
        boolean flag = piglinPrisoner.canAddToInventory(itemStack);
        if (itemStack.is(Items.GOLD_NUGGET)) {
            return flag;
        }
        if (!PiglinPrisonerAi.isLovedItem(itemStack)) {
            return piglinPrisoner.canReplaceCurrentItem(itemStack);
        }
        return PiglinPrisonerAi.isNotHoldingLovedItemInOffHand(piglinPrisoner) && flag;
    }

    public static boolean isLovedItem(ItemStack stack) {
        return stack.is(ItemTags.PIGLIN_LOVED);
    }

    private static boolean isNearestValidAttackTarget(PiglinPrisoner piglinPrisoner, LivingEntity target) {
        return PiglinPrisonerAi.findNearestValidAttackTarget(piglinPrisoner).filter(potentialTarget -> potentialTarget == target).isPresent();
    }

    private static boolean isNearZombified(PiglinPrisoner piglinPrisoner) {
        Brain<PiglinPrisoner> brain = piglinPrisoner.getBrain();
        if (brain.hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED)) {
            LivingEntity livingentity = (LivingEntity)brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED).get();
            return piglinPrisoner.closerThan((Entity)livingentity, 6.0);
        }
        return false;
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(PiglinPrisoner piglinPrisoner) {
        Brain<PiglinPrisoner> brain = piglinPrisoner.getBrain();
        if (PiglinPrisonerAi.isNearZombified(piglinPrisoner)) {
            return Optional.empty();
        }
        Optional optional = BehaviorUtils.getLivingEntityFromUUIDMemory((LivingEntity)piglinPrisoner, (MemoryModuleType)MemoryModuleType.ANGRY_AT);
        if (optional.isPresent() && Sensor.isEntityAttackableIgnoringLineOfSight((LivingEntity)piglinPrisoner, (LivingEntity)((LivingEntity)optional.get()))) {
            return optional;
        }
        Optional optional1 = brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_NEMESIS);
        if (optional1.isPresent()) {
            return optional1;
        }
        return Optional.empty();
    }

    public static InteractionResult mobInteract(PiglinPrisoner piglinPrisoner, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (PiglinPrisonerAi.canAdmire(piglinPrisoner, itemstack)) {
            ItemStack itemstack1 = itemstack.split(1);
            PiglinPrisonerAi.holdInOffhand(piglinPrisoner, itemstack1);
            if (!player.equals((Object)piglinPrisoner.getTempter())) {
                PiglinPrisonerAi.newTemptingPlayer(piglinPrisoner, player);
            }
            PiglinPrisonerAi.admireGoldItem(piglinPrisoner);
            PiglinPrisonerAi.stopWalking(piglinPrisoner);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public static boolean canAdmire(PiglinPrisoner piglinPrisoner, ItemStack itemStack) {
        return !PiglinPrisonerAi.isAdmiringDisabled(piglinPrisoner) && !PiglinPrisonerAi.isAdmiringItem(piglinPrisoner) && (CommonAbstractions.INSTANCE.isPiglinCurrency(itemStack) || PiglinPrisonerAi.isLovedItem(itemStack));
    }

    public static void wasHurtBy(PiglinPrisoner piglin, LivingEntity attacker) {
        if (attacker instanceof Piglin) {
            return;
        }
        if (PiglinPrisonerAi.isHoldingItemInOffHand(piglin)) {
            PiglinPrisonerAi.stopHoldingOffHandItem(piglin, false);
        }
        Brain<PiglinPrisoner> brain = piglin.getBrain();
        brain.eraseMemory(MemoryModuleType.CELEBRATE_LOCATION);
        brain.eraseMemory(MemoryModuleType.DANCING);
        brain.eraseMemory(MemoryModuleType.ADMIRING_ITEM);
        if (attacker instanceof Player) {
            brain.setMemoryWithExpiry(MemoryModuleType.ADMIRING_DISABLED, (Object)true, 400L);
        }
        PiglinPrisonerAi.getAvoidTarget(piglin).ifPresent(target -> {
            if (target.getType() != attacker.getType()) {
                brain.eraseMemory(MemoryModuleType.AVOID_TARGET);
            }
        });
        PiglinPrisonerAi.maybeRetaliate(piglin, attacker);
    }

    protected static void maybeRetaliate(AbstractPiglin piglin, LivingEntity target) {
        if (!piglin.getBrain().isActive(Activity.AVOID) && Sensor.isEntityAttackableIgnoringLineOfSight((LivingEntity)piglin, (LivingEntity)target) && !BehaviorUtils.isOtherTargetMuchFurtherAwayThanCurrentAttackTarget((LivingEntity)piglin, (LivingEntity)target, (double)4.0) && target.getType() != EntityType.PLAYER) {
            PiglinPrisonerAi.setAngerTarget(piglin, target);
            PiglinPrisonerAi.broadcastAngerTarget(piglin, target);
        }
    }

    public static Optional<SoundEvent> getSoundForCurrentActivity(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.getBrain().getActiveNonCoreActivity().map(activity -> PiglinPrisonerAi.getSoundForActivity(piglinPrisoner, activity));
    }

    private static SoundEvent getSoundForActivity(PiglinPrisoner piglinPrisoner, Activity activity) {
        if (activity == Activity.FIGHT) {
            return SoundEvents.PIGLIN_ANGRY;
        }
        if (piglinPrisoner.isConverting()) {
            return SoundEvents.PIGLIN_RETREAT;
        }
        if (activity == Activity.AVOID && PiglinPrisonerAi.isNearAvoidTarget(piglinPrisoner)) {
            return SoundEvents.PIGLIN_RETREAT;
        }
        if (activity == Activity.ADMIRE_ITEM) {
            return SoundEvents.PIGLIN_ADMIRING_ITEM;
        }
        if (activity == Activity.CELEBRATE) {
            return SoundEvents.PIGLIN_CELEBRATE;
        }
        if (PiglinPrisonerAi.seesPlayerHoldingLovedItem(piglinPrisoner)) {
            return SoundEvents.PIGLIN_JEALOUS;
        }
        return PiglinPrisonerAi.isNearRepellent(piglinPrisoner) ? SoundEvents.PIGLIN_RETREAT : SoundEvents.PIGLIN_AMBIENT;
    }

    private static boolean isNearAvoidTarget(PiglinPrisoner piglinPrisoner) {
        Brain<PiglinPrisoner> brain = piglinPrisoner.getBrain();
        return brain.hasMemoryValue(MemoryModuleType.AVOID_TARGET) && ((LivingEntity)brain.getMemory(MemoryModuleType.AVOID_TARGET).get()).closerThan((Entity)piglinPrisoner, 12.0);
    }

    private static void stopWalking(PiglinPrisoner piglinPrisoner) {
        piglinPrisoner.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        piglinPrisoner.getNavigation().stop();
    }

    public static void setAngerTarget(AbstractPiglin piglin, LivingEntity target) {
        if (Sensor.isEntityAttackableIgnoringLineOfSight((LivingEntity)piglin, (LivingEntity)target)) {
            piglin.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
            piglin.getBrain().setMemoryWithExpiry(MemoryModuleType.ANGRY_AT, (Object)target.getUUID(), 600L);
        }
    }

    private static boolean isNearRepellent(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_REPELLENT);
    }

    public static void exciteNearbyPiglins(Player player, boolean requireVisibility) {
        List list = player.level().getEntitiesOfClass(PiglinPrisoner.class, player.getBoundingBox().inflate(16.0));
        list.stream().filter(x$0 -> PiglinAi.isIdle((AbstractPiglin)x$0)).filter(piglin -> !requireVisibility || BehaviorUtils.canSee((LivingEntity)piglin, (LivingEntity)player)).forEach(PiglinPrisonerAi::startDancing);
    }

    public static void startDancing(PiglinPrisoner piglinPrisoner) {
        piglinPrisoner.getBrain().setMemoryWithExpiry(MemoryModuleType.DANCING, (Object)true, 200L);
        piglinPrisoner.getBrain().setMemoryWithExpiry(MemoryModuleType.CELEBRATE_LOCATION, (Object)piglinPrisoner.blockPosition(), 200L);
    }

    private static void startDancing(Piglin piglin) {
        piglin.getBrain().setMemoryWithExpiry(MemoryModuleType.DANCING, (Object)true, 200L);
        piglin.getBrain().setMemoryWithExpiry(MemoryModuleType.CELEBRATE_LOCATION, (Object)piglin.blockPosition(), 200L);
    }

    private static boolean seesPlayerHoldingLovedItem(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM);
    }

    private static boolean isHoldingItemInOffHand(PiglinPrisoner piglinPrisoner) {
        return !piglinPrisoner.getOffhandItem().isEmpty();
    }

    private static void admireGoldItem(PiglinPrisoner piglinPrisoner) {
        piglinPrisoner.getBrain().setMemoryWithExpiry(MemoryModuleType.ADMIRING_ITEM, (Object)true, 120L);
    }

    private static void putInInventory(PiglinPrisoner piglinPrisoner, ItemStack stack) {
        piglinPrisoner.addToInventory(stack);
        PiglinPrisonerAi.giveGoldBuff(piglinPrisoner);
        PiglinPrisonerAi.pledgeAllegiance(piglinPrisoner);
    }

    private static boolean hasCrossbow(LivingEntity livingentity) {
        return livingentity.isHolding(is -> is.getItem() instanceof CrossbowItem);
    }

    protected static void broadcastAngerTarget(AbstractPiglin piglin, LivingEntity target) {
        PiglinPrisonerAi.getAdultAbstractPiglins(piglin).forEach(adultPiglin -> PiglinPrisonerAi.setAngerTargetIfCloserThanCurrent(adultPiglin, target));
    }

    public static void broadcastBeingRescued(AbstractPiglin piglin) {
        PiglinPrisonerAi.getAdultPiglins(piglin).forEach(PiglinPrisonerAi::startDancing);
    }

    private static List<AbstractPiglin> getAdultAbstractPiglins(AbstractPiglin piglin) {
        return (List)piglin.getBrain().getMemory(MemoryModuleType.NEARBY_ADULT_PIGLINS).orElse(ImmutableList.of());
    }

    private static List<Piglin> getAdultPiglins(AbstractPiglin piglin) {
        return ((List)piglin.getBrain().getMemory(MemoryModuleType.NEARBY_ADULT_PIGLINS).orElse(ImmutableList.of())).stream().filter(abstractPiglin -> abstractPiglin instanceof Piglin).map(abstractPiglin -> (Piglin)abstractPiglin).toList();
    }

    private static void setAngerTargetIfCloserThanCurrent(AbstractPiglin piglin, LivingEntity target) {
        Optional<LivingEntity> optional = PiglinPrisonerAi.getAngerTarget(piglin);
        LivingEntity livingentity = BehaviorUtils.getNearestTarget((LivingEntity)piglin, optional, (LivingEntity)target);
        if (optional.isEmpty() || optional.get() != livingentity) {
            PiglinPrisonerAi.setAngerTarget(piglin, livingentity);
        }
    }

    private static Optional<LivingEntity> getAngerTarget(AbstractPiglin piglin) {
        return BehaviorUtils.getLivingEntityFromUUIDMemory((LivingEntity)piglin, (MemoryModuleType)MemoryModuleType.ANGRY_AT);
    }

    private static boolean isNotHoldingLovedItemInOffHand(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.getOffhandItem().isEmpty() || !PiglinPrisonerAi.isLovedItem(piglinPrisoner.getOffhandItem());
    }

    private static boolean isAdmiringItem(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.getBrain().hasMemoryValue(MemoryModuleType.ADMIRING_ITEM);
    }

    private static boolean isAdmiringDisabled(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.getBrain().hasMemoryValue(MemoryModuleType.ADMIRING_DISABLED);
    }

    public static Optional<LivingEntity> getAvoidTarget(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.getBrain().hasMemoryValue(MemoryModuleType.AVOID_TARGET) ? piglinPrisoner.getBrain().getMemory(MemoryModuleType.AVOID_TARGET) : Optional.empty();
    }

    public static boolean isPlayerHoldingLovedItem(LivingEntity player) {
        return player.getType() == EntityType.PLAYER && player.isHolding(PiglinPrisonerAi::isLovedItem);
    }

    private static boolean isFood(ItemStack stack) {
        return stack.is(ItemTags.PIGLIN_FOOD);
    }

    private static void eat(PiglinPrisoner piglinPrisoner) {
        piglinPrisoner.getBrain().setMemoryWithExpiry(MemoryModuleType.ATE_RECENTLY, (Object)true, 200L);
    }

    private static boolean hasEatenRecently(PiglinPrisoner piglinPrisoner) {
        return piglinPrisoner.getBrain().hasMemoryValue(MemoryModuleType.ATE_RECENTLY);
    }

    private static void giveGoldBuff(PiglinPrisoner piglinPrisoner) {
        piglinPrisoner.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 10800, 3, false, true));
        piglinPrisoner.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 7200, 1, false, false));
    }

    private static void newTemptingPlayer(PiglinPrisoner piglinPrisoner, Player player) {
        piglinPrisoner.getBrain().setMemory(MemoryModuleType.TEMPTING_PLAYER, (Object)player);
        piglinPrisoner.getBrain().setMemory(MemoryModuleType.IS_TEMPTED, (Object)false);
        piglinPrisoner.setTempterUUID(player.getUUID());
    }

    protected static void pledgeAllegiance(PiglinPrisoner piglinPrisoner) {
        if (piglinPrisoner.getBrain().hasMemoryValue(MemoryModuleType.TEMPTING_PLAYER)) {
            piglinPrisoner.getBrain().setMemory(MemoryModuleType.IS_TEMPTED, (Object)true);
        }
    }

    public static void reloadAllegiance(PiglinPrisoner piglinPrisoner, Player player) {
        piglinPrisoner.getBrain().setMemory(MemoryModuleType.TEMPTING_PLAYER, (Object)player);
        piglinPrisoner.getBrain().setMemory(MemoryModuleType.IS_TEMPTED, (Object)true);
    }
}

