/*
 * Decompiled with CFR 0.152.
 */
package net.imasillylittleguy.cnc.network;

import net.imasillylittleguy.cnc.CncMod;
import net.imasillylittleguy.cnc.client.toasts.FieldGuideNotificationToast;
import net.imasillylittleguy.cnc.client.toasts.MobsDisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record ShowToastMessage(String mobType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ShowToastMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cnc", (String)"show_toast"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ShowToastMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeUtf(message.mobType), buffer -> new ShowToastMessage(buffer.readUtf()));

    public CustomPacketPayload.Type<ShowToastMessage> type() {
        return TYPE;
    }

    public static void handleData(ShowToastMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.flow().isClientbound()) {
                ShowToastMessage.handleClientSide(message.mobType);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClientSide(String mobType) {
        MobsDisplayInfo displayInfo;
        switch (mobType) {
            case "elk": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.ELK;
                break;
            }
            case "wendigo": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.WENDIGO;
                break;
            }
            case "coyote": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.COYOTE;
                break;
            }
            case "timber_wolf": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.TIMBER_WOLF;
                break;
            }
            case "white_tailed_deer": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.WHITE_TAILED_DEER;
                break;
            }
            case "skinwalker": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.SKINWALKER;
                break;
            }
            case "cougar": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.COUGAR;
                break;
            }
            case "wolverine": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.WOLVERINE;
                break;
            }
            case "chupacabra": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.CHUPACABRA;
                break;
            }
            case "ringtail": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.RINGTAIL;
                break;
            }
            case "giant_boar": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.GIANT_BOAR;
                break;
            }
            case "squonk": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.SQUONK;
                break;
            }
            case "goose": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.GOOSE;
                break;
            }
            case "black_bear": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.BLACK_BEAR;
                break;
            }
            case "beaver": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.BEAVER;
                break;
            }
            case "howler": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.HOWLER;
                break;
            }
            case "sasquatch": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.SASQUATCH;
                break;
            }
            case "mouse": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.MOUSE;
                break;
            }
            case "snake": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.SNAKE;
                break;
            }
            case "rattlesnake": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.RATTLESNAKE;
                break;
            }
            case "pit_viper": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.PIT_VIPER;
                break;
            }
            case "wechuge": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.WECHUGE;
                break;
            }
            case "turkey": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.TURKEY;
                break;
            }
            case "caribou": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.CARIBOU;
                break;
            }
            case "skunk": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.SKUNK;
                break;
            }
            case "marmot": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.MARMOT;
                break;
            }
            case "mule_deer": {
                MobsDisplayInfo mobsDisplayInfo = MobsDisplayInfo.MULE_DEER;
                break;
            }
            default: {
                MobsDisplayInfo mobsDisplayInfo = displayInfo = null;
            }
        }
        if (displayInfo != null) {
            Minecraft.getInstance().getToasts().addToast((Toast)new FieldGuideNotificationToast(displayInfo));
        }
    }

    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        CncMod.addNetworkMessage(TYPE, STREAM_CODEC, ShowToastMessage::handleData);
    }
}

