/*
 * Decompiled with CFR 0.152.
 */
package net.imasillylittleguy.cnc.network;

import java.util.HashMap;
import java.util.Map;
import net.imasillylittleguy.cnc.CncMod;
import net.imasillylittleguy.cnc.procedures.FieldGuideCloseProcedure;
import net.imasillylittleguy.cnc.procedures.FieldGuideContentsOpenProcedure;
import net.imasillylittleguy.cnc.world.inventory.FieldGuideCougarMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record FieldGuideCougarButtonMessage(int buttonID, int x, int y, int z, HashMap<String, String> textstate) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FieldGuideCougarButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cnc", (String)"field_guide_cougar_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, FieldGuideCougarButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        FieldGuideCougarButtonMessage.writeTextState(message.textstate, buffer);
    }, buffer -> new FieldGuideCougarButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), FieldGuideCougarButtonMessage.readTextState(buffer)));

    public CustomPacketPayload.Type<FieldGuideCougarButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(FieldGuideCougarButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                HashMap<String, String> textstate = message.textstate;
                FieldGuideCougarButtonMessage.handleButtonAction(entity, buttonID, x, y, z, textstate);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        Level world = entity.level();
        HashMap<String, Object> guistate = FieldGuideCougarMenu.guistate;
        for (Map.Entry<String, String> entry : textstate.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            guistate.put(key, value);
        }
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == -2) {
            FieldGuideCloseProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 0) {
            FieldGuideContentsOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    private static void writeTextState(HashMap<String, String> map, RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            FieldGuideCougarButtonMessage.writeComponent(buffer, (Component)Component.literal((String)entry.getKey()));
            FieldGuideCougarButtonMessage.writeComponent(buffer, (Component)Component.literal((String)entry.getValue()));
        }
    }

    private static HashMap<String, String> readTextState(RegistryFriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = FieldGuideCougarButtonMessage.readComponent(buffer).getString();
            String value = FieldGuideCougarButtonMessage.readComponent(buffer).getString();
            map.put(key, value);
        }
        return map;
    }

    private static Component readComponent(RegistryFriendlyByteBuf buffer) {
        return (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)buffer);
    }

    private static void writeComponent(RegistryFriendlyByteBuf buffer, Component component) {
        ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buffer, (Object)component);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CncMod.addNetworkMessage(TYPE, STREAM_CODEC, FieldGuideCougarButtonMessage::handleData);
    }
}

