/*
 * Decompiled with CFR 0.152.
 */
package net.imasillylittleguy.cnc.init;

import net.imasillylittleguy.cnc.network.CaribouDashMessage;
import net.imasillylittleguy.cnc.network.WhistleMessage;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class CncModKeyMappings {
    public static final KeyMapping WHISTLE = new KeyMapping("key.cnc.whistle", -1, "key.categories.misc"){
        private boolean isDownOld = false;

        public void setDown(boolean isDown) {
            super.setDown(isDown);
            if (this.isDownOld != isDown && isDown) {
                WHISTLE_LASTPRESS = System.currentTimeMillis();
            } else if (this.isDownOld != isDown && !isDown) {
                int dt = (int)(System.currentTimeMillis() - WHISTLE_LASTPRESS);
                PacketDistributor.sendToServer((CustomPacketPayload)new WhistleMessage(1, dt), (CustomPacketPayload[])new CustomPacketPayload[0]);
                WhistleMessage.pressAction((Player)Minecraft.getInstance().player, 1, dt);
            }
            this.isDownOld = isDown;
        }
    };
    public static final KeyMapping CARIBOU_DASH = new KeyMapping("key.cnc.caribou_dash", 32, "key.categories.misc"){
        private boolean isDownOld = false;

        public void setDown(boolean isDown) {
            super.setDown(isDown);
            if (this.isDownOld != isDown && isDown) {
                PacketDistributor.sendToServer((CustomPacketPayload)new CaribouDashMessage(0, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                CaribouDashMessage.pressAction((Player)Minecraft.getInstance().player, 0, 0);
            }
            this.isDownOld = isDown;
        }
    };
    private static long WHISTLE_LASTPRESS = 0L;

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(WHISTLE);
        event.register(CARIBOU_DASH);
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class KeyEventListener {
        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Post event) {
            if (Minecraft.getInstance().screen == null) {
                WHISTLE.consumeClick();
                CARIBOU_DASH.consumeClick();
            }
        }
    }
}

