/*
 * Decompiled with CFR 0.152.
 */
package net.imasillylittleguy.cnc.entity;

import net.imasillylittleguy.cnc.entity.ElkEntity;
import net.imasillylittleguy.cnc.entity.WhitetailEntity;
import net.imasillylittleguy.cnc.init.CncModEntities;
import net.imasillylittleguy.cnc.procedures.WechugeAIStunProcedure;
import net.imasillylittleguy.cnc.procedures.WechugeNaturalEntitySpawningConditionProcedure;
import net.imasillylittleguy.cnc.procedures.WechugeOnEntityTickUpdateProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WechugeEntity
extends Monster
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(WechugeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(WechugeEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(WechugeEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_stunned = SynchedEntityData.defineId(WechugeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public WechugeEntity(EntityType<WechugeEntity> type, Level world) {
        super(type, world);
        this.xpReward = 30;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"wechuge");
        builder.define(DATA_stunned, (Object)false);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false){

            public boolean canUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canContinueToUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, ServerPlayer.class, false, false){

            public boolean canUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canContinueToUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, false, false){

            public boolean canUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canContinueToUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, false, false){

            public boolean canUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canContinueToUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, ZombieVillager.class, false, false){

            public boolean canUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canContinueToUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Pillager.class, false, false){

            public boolean canUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canContinueToUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Vindicator.class, false, false){

            public boolean canUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canContinueToUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, WhitetailEntity.class, false, false){

            public boolean canUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canContinueToUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, ElkEntity.class, false, false){

            public boolean canUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canContinueToUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(10, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canContinueToUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }
        }.setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(11, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 4.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canContinueToUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(12, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.level()));
        this.goalSelector.addGoal(13, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canContinueToUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(14, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(15, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(16, (Goal)new BreakDoorGoal((Mob)this, e -> true){

            public boolean canUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = WechugeEntity.this.getX();
                double y = WechugeEntity.this.getY();
                double z = WechugeEntity.this.getZ();
                WechugeEntity entity = WechugeEntity.this;
                Level world = WechugeEntity.this.level();
                return super.canContinueToUse() && WechugeAIStunProcedure.execute((Entity)entity);
            }
        });
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"cnc:entity.wechuge.idle"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"cnc:entity.wechuge.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"cnc:entity.wechuge.growl"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"cnc:entity.wechuge.death"));
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getDirectEntity() instanceof AbstractArrow) {
            return false;
        }
        if (source.getDirectEntity() instanceof ThrownPotion || source.getDirectEntity() instanceof AreaEffectCloud || source.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        if (source.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
        compound.putBoolean("Datastunned", ((Boolean)this.entityData.get(DATA_stunned)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
        if (compound.contains("Datastunned")) {
            this.entityData.set(DATA_stunned, (Object)compound.getBoolean("Datastunned"));
        }
    }

    public void baseTick() {
        super.baseTick();
        WechugeOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.0f);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)CncModEntities.WECHUGE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return WechugeNaturalEntitySpawningConditionProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.2);
        builder = builder.add(Attributes.MAX_HEALTH, 200.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 10.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.1);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 0.1);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (!(!event.isMoving() && event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || this.isAggressive() || this.isSprinting())) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.wechuge.walk"));
            }
            if (this.isSprinting()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.wechuge.charge"));
            }
            if (this.isAggressive() && event.isMoving()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.wechuge.charge"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.wechuge.idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.getX() - this.xOld;
        double d0 = this.getZ() - this.zOld;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.getAttackAnim(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.level().getGameTime();
        }
        if (this.swinging && this.lastSwing + 7L <= this.level().getGameTime()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.wechuge.hit"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 20) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience((Entity)this);
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "attacking", 4, this::attackingPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

