/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.blocks.customs;

import com.simibubi.create.api.contraption.transformable.TransformableBlock;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.chainDrive.ChainDriveBlock;
import com.simibubi.create.content.kinetics.chainDrive.ChainGearshiftBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import fr.iglee42.createcasing.registries.ModBlockEntities;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;

public class CustomChainDriveBlock
extends RotatedPillarKineticBlock
implements IBE<KineticBlockEntity>,
TransformableBlock {
    public static final Property<ChainDriveBlock.Part> PART = EnumProperty.create((String)"part", ChainDriveBlock.Part.class);
    public static final BooleanProperty CONNECTED_ALONG_FIRST_COORDINATE = DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE;
    private final String type;

    public CustomChainDriveBlock(BlockBehaviour.Properties properties, String type) {
        super(properties);
        this.type = type;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(PART, (Comparable)ChainDriveBlock.Part.NONE));
    }

    public String getType() {
        return this.type;
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.NORMAL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{PART, CONNECTED_ALONG_FIRST_COORDINATE}));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction.Axis axis;
        Direction.Axis placedAxis = context.getNearestLookingDirection().getAxis();
        Direction.Axis axis2 = axis = context.getPlayer() != null && context.getPlayer().isShiftKeyDown() ? placedAxis : CustomChainDriveBlock.getPreferredAxis((BlockPlaceContext)context);
        if (axis == null) {
            axis = placedAxis;
        }
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)axis);
        for (Direction facing : Iterate.directions) {
            if (facing.getAxis() == axis) continue;
            BlockPos pos = context.getClickedPos();
            BlockPos offset = pos.relative(facing);
            state = this.updateShape(state, facing, context.getLevel().getBlockState(offset), (LevelAccessor)context.getLevel(), pos, offset);
        }
        return state;
    }

    public BlockState updateShape(BlockState stateIn, Direction face, BlockState neighbour, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        CustomChainDriveBlock b;
        Block block = neighbour.getBlock();
        if (block instanceof CustomChainDriveBlock && this.type.equals((b = (CustomChainDriveBlock)block).getType()) || neighbour.isAir()) {
            Direction.Axis otherConnectionAxis;
            boolean positive;
            ChainDriveBlock.Part part = (ChainDriveBlock.Part)stateIn.getValue(PART);
            Direction.Axis axis = (Direction.Axis)stateIn.getValue((Property)AXIS);
            boolean connectionAlongFirst = (Boolean)stateIn.getValue((Property)CONNECTED_ALONG_FIRST_COORDINATE);
            Direction.Axis connectionAxis = connectionAlongFirst ? (axis == Direction.Axis.X ? Direction.Axis.Y : Direction.Axis.X) : (axis == Direction.Axis.Z ? Direction.Axis.Y : Direction.Axis.Z);
            Direction.Axis faceAxis = face.getAxis();
            boolean facingAlongFirst = axis == Direction.Axis.X ? faceAxis.isVertical() : faceAxis == Direction.Axis.X;
            boolean bl = positive = face.getAxisDirection() == Direction.AxisDirection.POSITIVE;
            if (axis == faceAxis) {
                return stateIn;
            }
            if (!(neighbour.getBlock() instanceof CustomChainDriveBlock)) {
                if (facingAlongFirst != connectionAlongFirst || part == ChainDriveBlock.Part.NONE) {
                    return stateIn;
                }
                if (part == ChainDriveBlock.Part.MIDDLE) {
                    return (BlockState)stateIn.setValue(PART, (Comparable)(positive ? ChainDriveBlock.Part.END : ChainDriveBlock.Part.START));
                }
                if (part == ChainDriveBlock.Part.START == positive) {
                    return (BlockState)stateIn.setValue(PART, (Comparable)ChainDriveBlock.Part.NONE);
                }
                return stateIn;
            }
            ChainDriveBlock.Part otherPart = (ChainDriveBlock.Part)neighbour.getValue(PART);
            Direction.Axis otherAxis = (Direction.Axis)neighbour.getValue((Property)AXIS);
            boolean otherConnection = (Boolean)neighbour.getValue((Property)CONNECTED_ALONG_FIRST_COORDINATE);
            Direction.Axis axis2 = otherConnection ? (otherAxis == Direction.Axis.X ? Direction.Axis.Y : Direction.Axis.X) : (otherConnectionAxis = otherAxis == Direction.Axis.Z ? Direction.Axis.Y : Direction.Axis.Z);
            if (neighbour.getValue((Property)AXIS) == faceAxis) {
                return stateIn;
            }
            if (otherPart != ChainDriveBlock.Part.NONE && otherConnectionAxis != faceAxis) {
                return stateIn;
            }
            if (part == ChainDriveBlock.Part.NONE) {
                ChainDriveBlock.Part part2 = part = positive ? ChainDriveBlock.Part.START : ChainDriveBlock.Part.END;
                connectionAlongFirst = axis == Direction.Axis.X ? faceAxis.isVertical() : faceAxis == Direction.Axis.X;
            } else if (connectionAxis != faceAxis) {
                return stateIn;
            }
            if (part == ChainDriveBlock.Part.START != positive) {
                part = ChainDriveBlock.Part.MIDDLE;
            }
            return (BlockState)((BlockState)stateIn.setValue(PART, (Comparable)part)).setValue((Property)CONNECTED_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(connectionAlongFirst));
        }
        return stateIn;
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (originalState.getValue(PART) == ChainDriveBlock.Part.NONE) {
            return super.getRotatedBlockState(originalState, targetedFace);
        }
        return super.getRotatedBlockState(originalState, Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)CustomChainDriveBlock.getConnectionAxis(originalState)));
    }

    public BlockState updateAfterWrenched(BlockState newState, UseOnContext context) {
        Direction.Axis axis = (Direction.Axis)newState.getValue((Property)AXIS);
        newState = (BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)axis);
        if (newState.hasProperty((Property)BlockStateProperties.POWERED)) {
            newState = (BlockState)newState.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
        }
        for (Direction facing : Iterate.directions) {
            if (facing.getAxis() == axis) continue;
            BlockPos pos = context.getClickedPos();
            BlockPos offset = pos.relative(facing);
            newState = this.updateShape(newState, facing, context.getLevel().getBlockState(offset), (LevelAccessor)context.getLevel(), pos, offset);
        }
        return newState;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.getAxis() == state.getValue((Property)AXIS);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.getValue((Property)AXIS);
    }

    public static boolean areBlocksConnected(BlockState state, BlockState other, Direction facing) {
        block7: {
            block6: {
                Block block = state.getBlock();
                if (!(block instanceof CustomChainDriveBlock)) break block6;
                CustomChainDriveBlock b = (CustomChainDriveBlock)block;
                block = other.getBlock();
                if (!(block instanceof CustomChainDriveBlock)) break block6;
                CustomChainDriveBlock b1 = (CustomChainDriveBlock)block;
                if (b.getType().equals(b1.getType())) break block7;
            }
            return false;
        }
        ChainDriveBlock.Part part = (ChainDriveBlock.Part)state.getValue(PART);
        Direction.Axis connectionAxis = CustomChainDriveBlock.getConnectionAxis(state);
        Direction.Axis otherConnectionAxis = CustomChainDriveBlock.getConnectionAxis(other);
        if (otherConnectionAxis != connectionAxis) {
            return false;
        }
        if (facing.getAxis() != connectionAxis) {
            return false;
        }
        if (facing.getAxisDirection() == Direction.AxisDirection.POSITIVE && (part == ChainDriveBlock.Part.MIDDLE || part == ChainDriveBlock.Part.START)) {
            return true;
        }
        return facing.getAxisDirection() == Direction.AxisDirection.NEGATIVE && (part == ChainDriveBlock.Part.MIDDLE || part == ChainDriveBlock.Part.END);
    }

    protected static Direction.Axis getConnectionAxis(BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)AXIS);
        boolean connectionAlongFirst = (Boolean)state.getValue((Property)CONNECTED_ALONG_FIRST_COORDINATE);
        Direction.Axis connectionAxis = connectionAlongFirst ? (axis == Direction.Axis.X ? Direction.Axis.Y : Direction.Axis.X) : (axis == Direction.Axis.Z ? Direction.Axis.Y : Direction.Axis.Z);
        return connectionAxis;
    }

    public static float getRotationSpeedModifier(KineticBlockEntity from, KineticBlockEntity to) {
        float fromMod = 1.0f;
        float toMod = 1.0f;
        if (from instanceof ChainGearshiftBlockEntity) {
            fromMod = ((ChainGearshiftBlockEntity)from).getModifier();
        }
        if (to instanceof ChainGearshiftBlockEntity) {
            toMod = ((ChainGearshiftBlockEntity)to).getModifier();
        }
        return fromMod / toMod;
    }

    public Class<KineticBlockEntity> getBlockEntityClass() {
        return KineticBlockEntity.class;
    }

    public BlockEntityType<? extends KineticBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.ENCASED_SHAFT.get();
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return this.rotate(state, rot, Direction.Axis.Y);
    }

    protected BlockState rotate(BlockState pState, Rotation rot, Direction.Axis rotAxis) {
        Direction.Axis connectionAxis = CustomChainDriveBlock.getConnectionAxis(pState);
        Direction direction = Direction.fromAxisAndDirection((Direction.Axis)connectionAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        Direction normal = Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)pState.getValue((Property)AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        for (int i = 0; i < rot.ordinal(); ++i) {
            direction = direction.getClockWise(rotAxis);
            normal = normal.getClockWise(rotAxis);
        }
        if (direction.getAxisDirection() == Direction.AxisDirection.NEGATIVE) {
            pState = this.reversePart(pState);
        }
        Direction.Axis newAxis = normal.getAxis();
        Direction.Axis newConnectingDirection = direction.getAxis();
        boolean alongFirst = newAxis == Direction.Axis.X && newConnectingDirection == Direction.Axis.Y || newAxis != Direction.Axis.X && newConnectingDirection == Direction.Axis.X;
        return (BlockState)((BlockState)pState.setValue((Property)AXIS, (Comparable)newAxis)).setValue((Property)CONNECTED_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(alongFirst));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        Direction.Axis connectionAxis = CustomChainDriveBlock.getConnectionAxis(pState);
        if (pMirror.mirror(Direction.fromAxisAndDirection((Direction.Axis)connectionAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)).getAxisDirection() == Direction.AxisDirection.POSITIVE) {
            return pState;
        }
        return this.reversePart(pState);
    }

    protected BlockState reversePart(BlockState pState) {
        ChainDriveBlock.Part part = (ChainDriveBlock.Part)pState.getValue(PART);
        if (part == ChainDriveBlock.Part.START) {
            return (BlockState)pState.setValue(PART, (Comparable)ChainDriveBlock.Part.END);
        }
        if (part == ChainDriveBlock.Part.END) {
            return (BlockState)pState.setValue(PART, (Comparable)ChainDriveBlock.Part.START);
        }
        return pState;
    }

    public BlockState transform(BlockState state, StructureTransform transform) {
        return this.rotate(this.mirror(state, transform.mirror), transform.rotation, transform.rotationAxis);
    }
}

