/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.blockEntities.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import fr.iglee42.createcasing.blockEntities.GlassShaftBlockEntity;
import fr.iglee42.createcasing.registries.ModPartialModels;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class GlassShaftRenderer
extends KineticBlockEntityRenderer<GlassShaftBlockEntity> {
    public GlassShaftRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(GlassShaftBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        Direction.Axis axis = GlassShaftRenderer.getRotationAxisOf((KineticBlockEntity)be);
        Direction facing = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        float angle = GlassShaftRenderer.getAngleForLargeCogShaft((SimpleKineticBlockEntity)be, axis);
        SuperByteBuffer shaft = CachedBuffers.partialFacingVertical((PartialModel)ModPartialModels.GLASS_SHAFT, (BlockState)be.getBlockState(), (Direction)facing);
        GlassShaftRenderer.kineticRotationTransform((SuperByteBuffer)shaft, (KineticBlockEntity)be, (Direction.Axis)axis, (float)angle, (int)light);
        shaft.renderInto(ms, buffer.getBuffer(RenderType.cutoutMipped()));
    }

    public static float getAngleForLargeCogShaft(SimpleKineticBlockEntity be, Direction.Axis axis) {
        BlockPos pos = be.getBlockPos();
        float offset = GlassShaftRenderer.getShaftAngleOffset(axis, pos);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel());
        float angle = (time * be.getSpeed() * 3.0f / 10.0f + offset) % 360.0f / 180.0f * (float)Math.PI;
        return angle;
    }

    public static float getShaftAngleOffset(Direction.Axis axis, BlockPos pos) {
        float offset = 0.0f;
        double d = ((axis == Direction.Axis.X ? 0 : pos.getX()) + (axis == Direction.Axis.Y ? 0 : pos.getY()) + (axis == Direction.Axis.Z ? 0 : pos.getZ())) % 2;
        if (d == 0.0) {
            offset = 22.5f;
        }
        return offset;
    }
}

