/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.blockEntities.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import fr.iglee42.createcasing.blockEntities.CustomMixerBlockEntity;
import fr.iglee42.createcasing.registries.ModPartialModels;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class CustomMixerRenderer
extends KineticBlockEntityRenderer<CustomMixerBlockEntity> {
    public CustomMixerRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public boolean shouldRenderOffScreen(CustomMixerBlockEntity be) {
        return true;
    }

    protected void renderSafe(CustomMixerBlockEntity mixer, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)mixer.getLevel())) {
            return;
        }
        BlockState blockState = mixer.getBlockState();
        VertexConsumer vb = buffer.getBuffer(RenderType.solid());
        SuperByteBuffer superBuffer = CachedBuffers.partial((PartialModel)AllPartialModels.SHAFTLESS_COGWHEEL, (BlockState)blockState);
        CustomMixerRenderer.standardKineticRotationTransform((SuperByteBuffer)superBuffer, (KineticBlockEntity)mixer, (int)light).renderInto(ms, vb);
        float renderedHeadOffset = mixer.getRenderedHeadOffset(partialTicks);
        float speed = mixer.getRenderedHeadRotationSpeed(partialTicks);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)mixer.getLevel());
        float angle = time * speed * 6.0f / 10.0f % 360.0f / 180.0f * (float)Math.PI;
        SuperByteBuffer poleRender = CachedBuffers.partial((PartialModel)AllPartialModels.MECHANICAL_MIXER_POLE, (BlockState)blockState);
        SuperByteBuffer headRender = CachedBuffers.partial((PartialModel)AllPartialModels.MECHANICAL_MIXER_HEAD, (BlockState)blockState);
        SuperByteBuffer oldHeadRender = CachedBuffers.partial((PartialModel)AllPartialModels.MECHANICAL_MIXER_HEAD, (BlockState)blockState);
        switch (BuiltInRegistries.BLOCK.getKey((Object)mixer.getBlockState().getBlock()).getPath().replace("_mixer", "").toLowerCase()) {
            case "brass": {
                headRender = CachedBuffers.partial((PartialModel)ModPartialModels.BRASS_MIXER_HEAD, (BlockState)blockState);
                break;
            }
            case "copper": {
                headRender = CachedBuffers.partial((PartialModel)ModPartialModels.COPPER_MIXER_HEAD, (BlockState)blockState);
                break;
            }
            case "railway": {
                headRender = CachedBuffers.partial((PartialModel)ModPartialModels.RAILWAY_MIXER_HEAD, (BlockState)blockState);
                break;
            }
            case "industrial_iron": {
                headRender = CachedBuffers.partial((PartialModel)ModPartialModels.INDUSTRIAL_IRON_MIXER_HEAD, (BlockState)blockState);
                break;
            }
            default: {
                headRender = CachedBuffers.partial((PartialModel)AllPartialModels.MECHANICAL_MIXER_HEAD, (BlockState)blockState);
            }
        }
        if (headRender == oldHeadRender) {
            return;
        }
        ((SuperByteBuffer)poleRender.translate(0.0f, -renderedHeadOffset, 0.0f)).light(light).renderInto(ms, vb);
        VertexConsumer vbCutout = buffer.getBuffer(RenderType.cutoutMipped());
        ((SuperByteBuffer)((SuperByteBuffer)headRender.rotateCentered(angle, Direction.UP)).translate(0.0f, -renderedHeadOffset, 0.0f)).light(light).renderInto(ms, vbCutout);
    }
}

