/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.citycraft.utils;

import com.mojang.authlib.GameProfile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Scanner;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.VersionChecker;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforgespi.language.IModInfo;
import xxrexraptorxx.citycraft.main.CityCraft;
import xxrexraptorxx.citycraft.utils.Config;

@EventBusSubscriber(modid="citycraft", bus=EventBusSubscriber.Bus.GAME)
public class Events {
    private static boolean hasShownUp = false;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        if (Config.UPDATE_CHECKER != null && ((Boolean)Config.UPDATE_CHECKER.get()).booleanValue() && !hasShownUp && Minecraft.getInstance().screen == null) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            ModContainer modContainer = ModList.get().getModContainerById("citycraft").orElse(null);
            if (modContainer != null) {
                VersionChecker.CheckResult versionCheckResult = VersionChecker.getResult((IModInfo)modContainer.getModInfo());
                if (versionCheckResult.status() == VersionChecker.Status.OUTDATED || versionCheckResult.status() == VersionChecker.Status.BETA_OUTDATED) {
                    MutableComponent url = Component.translatable((String)(String.valueOf(ChatFormatting.GREEN) + "Click here to update!")).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/citycraft")));
                    player.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + "A newer version of " + String.valueOf(ChatFormatting.YELLOW) + "City Craft" + String.valueOf(ChatFormatting.BLUE) + " is available!")), false);
                    player.displayClientMessage((Component)url, false);
                    hasShownUp = true;
                } else if (versionCheckResult.status() == VersionChecker.Status.FAILED) {
                    CityCraft.LOGGER.error("City Craft's version checker failed!");
                    hasShownUp = true;
                }
            }
        }
    }

    @SubscribeEvent
    public static void SupporterRewards(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (((Boolean)Config.PATREON_REWARDS.get()).booleanValue()) {
            try {
                ServerPlayer serverPlayer;
                URL SUPPORTER_URL = new URL("https://raw.githubusercontent.com/XxRexRaptorxX/Patreons/main/Supporter");
                URL PREMIUM_SUPPORTER_URL = new URL("https://raw.githubusercontent.com/XxRexRaptorxX/Patreons/main/Premium%20Supporter");
                URL ELITE_URL = new URL("https://raw.githubusercontent.com/XxRexRaptorxX/Patreons/main/Elite");
                if (!player.getInventory().contains(new ItemStack((ItemLike)Items.PAPER)) && (serverPlayer = (ServerPlayer)player).getStats().getValue(Stats.CUSTOM, (Object)Stats.PLAY_TIME) < 5) {
                    if (Events.SupporterCheck(SUPPORTER_URL, player)) {
                        ItemStack certificate = new ItemStack((ItemLike)Items.PAPER);
                        certificate.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Thank you for supporting me in my work!").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)" - XxRexRaptorxX").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GREEN)));
                        ItemStack reward = new ItemStack((ItemLike)Items.PLAYER_HEAD);
                        GameProfile profile = new GameProfile(player.getUUID(), player.getName().getString());
                        reward.set(DataComponents.PROFILE, (Object)new ResolvableProfile(profile));
                        level.playSound((Player)null, player.blockPosition(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 0.5f, level.random.nextFloat() * 0.15f + 0.8f);
                        player.addItem(reward);
                        player.addItem(certificate);
                    }
                    if (Events.SupporterCheck(PREMIUM_SUPPORTER_URL, player)) {
                        ItemStack reward = new ItemStack((ItemLike)Items.DIAMOND_SWORD, 1);
                        Registry enchantmentsRegistry = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
                        reward.enchant((Holder)enchantmentsRegistry.getHolderOrThrow(Enchantments.MENDING), 1);
                        reward.enchant((Holder)enchantmentsRegistry.getHolderOrThrow(Enchantments.SHARPNESS), 3);
                        reward.set(DataComponents.ENCHANTMENTS, (Object)((ItemEnchantments)reward.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)));
                        reward.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Rex's Night Sword").withStyle(ChatFormatting.DARK_GRAY));
                        player.addItem(reward);
                    }
                    if (Events.SupporterCheck(ELITE_URL, player)) {
                        ItemStack star = new ItemStack((ItemLike)Items.NETHER_STAR);
                        star.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Elite Star"));
                        player.addItem(star);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean SupporterCheck(URL url, Player player) {
        try {
            Scanner scanner = new Scanner(url.openStream());
            List<String> supporterList = scanner.tokens().toList();
            for (String name : supporterList) {
                if (!player.getName().getString().equals(name)) continue;
                return true;
            }
            scanner.close();
        }
        catch (MalformedURLException e) {
            CityCraft.LOGGER.error("Supporter list URL not found! >>" + String.valueOf(url));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

