/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.citycraft.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import xxrexraptorxx.citycraft.main.CityCraft;
import xxrexraptorxx.citycraft.recipes.IPaintingRecipe;
import xxrexraptorxx.citycraft.registry.ModRecipeSerializers;
import xxrexraptorxx.citycraft.registry.ModRecipeTypes;

public class PaintingRecipe
implements IPaintingRecipe {
    private final ResourceLocation id;
    final Ingredient base;
    final Ingredient color;
    final ItemStack result;

    public PaintingRecipe(ResourceLocation id, Ingredient baseIngredient, Ingredient colorIngredient, ItemStack result) {
        this.id = id;
        this.base = baseIngredient;
        this.color = colorIngredient;
        this.result = result;
    }

    public boolean matches(RecipeInput input, Level level) {
        return this.base.test(input.getItem(0)) && this.color.test(input.getItem(1));
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    @Override
    public Ingredient getIngredients(Integer slotId) {
        switch (slotId) {
            case 0: {
                return this.base;
            }
            case 1: {
                return this.color;
            }
        }
        CityCraft.LOGGER.error("Invalid Ingredient slot id: " + String.valueOf(this.id));
        return null;
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    @Override
    public boolean isColorIngredient(ItemStack stack) {
        return this.color.test(stack);
    }

    @Override
    public boolean isBaseIngredient(ItemStack stack) {
        return this.base.test(stack);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.PAINTING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.PAINTING.get();
    }

    public boolean isIncomplete() {
        return Stream.of(this.color, this.base).anyMatch(Ingredient::hasNoItems);
    }

    public static class Serializer
    implements RecipeSerializer<PaintingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<PaintingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("type").forGetter(recipe -> recipe.id), (App)Ingredient.CODEC.fieldOf("base").forGetter(recipe -> recipe.base), (App)Ingredient.CODEC.fieldOf("color").forGetter(recipe -> recipe.color), (App)ItemStack.OPTIONAL_CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)builder, PaintingRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, PaintingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        private static PaintingRecipe read(RegistryFriendlyByteBuf buf) {
            ResourceLocation id = buf.readResourceLocation();
            Ingredient base = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            Ingredient color = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            ItemStack result = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
            return new PaintingRecipe(id, base, color, result);
        }

        private static void write(RegistryFriendlyByteBuf buf, PaintingRecipe recipe) {
            buf.writeResourceLocation(recipe.getId());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.base);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.color);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)recipe.result);
        }

        public MapCodec<PaintingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PaintingRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }
    }
}

