/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.citycraft.blocks;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import xxrexraptorxx.citycraft.utils.Config;

public class DrainCoverBlock
extends SlabBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public DrainCoverBlock() {
        super(BlockBehaviour.Properties.of().strength(5.5f, 6.5f).sound(SoundType.METAL).mapColor(MapColor.METAL).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresCorrectToolForDrops().noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockPos above = pos.above();
        BlockPos below = pos.below();
        FluidState fluidStateAbove = level.getFluidState(above);
        FluidState fluidStateBelow = level.getFluidState(below);
        if (fluidStateAbove.is(FluidTags.WATER)) {
            BlockState blockStateBelow;
            state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            if (fluidStateBelow.getType() == Fluids.EMPTY && (blockStateBelow = level.getBlockState(below)).isAir()) {
                level.setBlock(below, fluidStateAbove.createLegacyBlock(), 2);
            }
        } else {
            if (fluidStateBelow.getType() != Fluids.EMPTY) {
                level.setBlock(below, Blocks.AIR.defaultBlockState(), 3);
            }
            state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos above = pos.above();
        BlockPos below = pos.below();
        AABB itemCheckBox = new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(above.getX() + 1), (double)(above.getY() + 1), (double)(above.getZ() + 1));
        if (!level.getEntitiesOfClass(ItemEntity.class, itemCheckBox).isEmpty()) {
            level.getEntitiesOfClass(ItemEntity.class, itemCheckBox).forEach(itemEntity -> {
                ItemStack stack = itemEntity.getItem();
                itemEntity.setPos(itemEntity.getX(), (double)below.getY(), itemEntity.getZ());
            });
        }
        level.scheduleTick(pos, (Block)this, 5);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.isClientSide) {
            level.scheduleTick(pos, (Block)this, 20);
        }
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TYPE, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = context.getLevel().getBlockState(blockpos);
        if (blockstate.is((Block)this)) {
            return (BlockState)((BlockState)((BlockState)blockstate.setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)TYPE, (Comparable)SlabType.DOUBLE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        FluidState fluidstate = context.getLevel().getFluidState(blockpos);
        BlockState blockstate1 = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        Direction direction = context.getClickedFace();
        return !(direction == Direction.DOWN || direction != Direction.UP && context.getClickLocation().y - (double)blockpos.getY() > 0.5) ? blockstate1 : (BlockState)blockstate1.setValue((Property)TYPE, (Comparable)SlabType.TOP);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        if (((Boolean)Config.ENABLE_TOOLTIPS.get()).booleanValue()) {
            list.add((Component)Component.translatable((String)"message.citycraft.drain_cover_tooltip").withStyle(ChatFormatting.GRAY));
        }
    }
}

