/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.citycraft.blocks;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import xxrexraptorxx.citycraft.registry.ModBlocks;
import xxrexraptorxx.citycraft.utils.Config;

public class AsphaltBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<AsphaltBlock> CODEC = AsphaltBlock.simpleCodec(AsphaltBlock::new);

    public AsphaltBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public AsphaltBlock() {
        super(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(1.6f).sound(SoundType.STONE).mapColor(DyeColor.BLACK).instrument(NoteBlockInstrument.BASEDRUM));
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        boolean isRegularAsphalt;
        if (level.isClientSide || entity == null) {
            return;
        }
        boolean isBoostAsphalt = this == ModBlocks.BOOST_ASPHALT.get();
        boolean bl = isRegularAsphalt = !isBoostAsphalt && (Boolean)Config.ENABLE_ASPHALT_SPEED_EFFECT.get() != false;
        if (isRegularAsphalt || isBoostAsphalt) {
            int duration = isBoostAsphalt ? 30 : 10;
            int amplifier = isBoostAsphalt ? (Integer)Config.BOOST_SPEED_EFFECT_AMPLIFIER.get() : (Integer)Config.SPEED_EFFECT_AMPLIFIER.get();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, duration, amplifier, false, false, true));
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        if (((Boolean)Config.ENABLE_TOOLTIPS.get()).booleanValue()) {
            if (this == ModBlocks.BOOST_ASPHALT.get()) {
                list.add((Component)Component.translatable((String)"message.citycraft.boost_speed_tooltip").withStyle(ChatFormatting.GRAY));
            } else if (((Boolean)Config.ENABLE_ASPHALT_SPEED_EFFECT.get()).booleanValue() && this != ModBlocks.POTHOLE_ASPHALT.get()) {
                list.add((Component)Component.translatable((String)"message.citycraft.speed_tooltip").withStyle(ChatFormatting.GRAY));
            }
        }
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

