/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder.mixin.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.popcraft.chunky.platform.util.Vector2;
import org.popcraft.chunky.shape.ShapeUtil;
import org.popcraft.chunkyborder.ChunkyBorderNeoForge;
import org.popcraft.chunkyborder.shape.BorderShape;
import org.popcraft.chunkyborder.shape.EllipseBorderShape;
import org.popcraft.chunkyborder.shape.PolygonBorderShape;
import org.popcraft.chunkyborder.util.BorderColor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Shadow
    @Final
    private static ResourceLocation FORCEFIELD_LOCATION;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private ClientLevel level;

    @Inject(method={"renderWorldBorder(Lnet/minecraft/client/Camera;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderWorldBorder(Camera camera, CallbackInfo ci) {
        BorderShape borderShape = ChunkyBorderNeoForge.getBorderShape(this.level.dimension().location());
        if (borderShape == null) {
            return;
        }
        double renderDistanceBlocks = (double)this.minecraft.options.getEffectiveRenderDistance() * 16.0;
        double posX = camera.getPosition().x;
        double posZ = camera.getPosition().z;
        double height = this.minecraft.gameRenderer.getDepthFar();
        double distanceInsideBorder = Double.MAX_VALUE;
        if (borderShape instanceof PolygonBorderShape) {
            PolygonBorderShape polygon = (PolygonBorderShape)borderShape;
            double[] pointsX = polygon.getPointsX();
            double[] pointsZ = polygon.getPointsZ();
            for (int i = 0; i < pointsX.length; ++i) {
                double p2z;
                double p1x = pointsX[i];
                double p1z = pointsZ[i];
                double p2x = pointsX[i + 1 == pointsX.length ? 0 : i + 1];
                Vector2 closestPoint = ShapeUtil.closestPointOnLine((double)posX, (double)posZ, (double)p1x, (double)p1z, (double)p2x, (double)(p2z = pointsZ[i + 1 == pointsZ.length ? 0 : i + 1]));
                double distanceToBorder = ShapeUtil.distanceBetweenPoints((double)posX, (double)posZ, (double)closestPoint.getX(), (double)closestPoint.getZ());
                if (!(distanceToBorder < distanceInsideBorder)) continue;
                distanceInsideBorder = distanceToBorder;
            }
        } else if (borderShape instanceof EllipseBorderShape) {
            EllipseBorderShape ellipse = (EllipseBorderShape)borderShape;
            double centerX = ellipse.getCenterX();
            double centerZ = ellipse.getCenterZ();
            double radiusX = ellipse.getRadiusX();
            double radiusZ = ellipse.getRadiusZ();
            double cameraAngle = Math.atan2(radiusX * (posZ - centerZ), radiusZ * (posX - centerX));
            Vector2 pointOnBorder = ShapeUtil.pointOnEllipse((double)centerX, (double)centerZ, (double)radiusX, (double)radiusZ, (double)cameraAngle);
            distanceInsideBorder = ShapeUtil.distanceBetweenPoints((double)posX, (double)posZ, (double)pointOnBorder.getX(), (double)pointOnBorder.getZ());
        }
        if (distanceInsideBorder < renderDistanceBlocks) {
            MeshData meshdata;
            double alpha = 1.0 - distanceInsideBorder / renderDistanceBlocks;
            alpha = Math.pow(alpha, 4.0);
            alpha = this.clamp(alpha, 0.0, 1.0);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)FORCEFIELD_LOCATION);
            RenderSystem.depthMask((boolean)Minecraft.useShaderTransparency());
            int color = BorderColor.getColor();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)((float)alpha));
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
            RenderSystem.enablePolygonOffset();
            RenderSystem.disableCull();
            float offset = (float)(Util.getMillis() % 3000L) / 3000.0f;
            float textureVertical = (float)(height - Mth.frac((double)camera.getPosition().y));
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            float textureSize = 0.5f;
            if (borderShape instanceof PolygonBorderShape) {
                PolygonBorderShape polygon = (PolygonBorderShape)borderShape;
                double[] pointsX = polygon.getPointsX();
                double[] pointsZ = polygon.getPointsZ();
                block1: for (int i = 0; i < pointsX.length; ++i) {
                    double p2z;
                    double p1x = pointsX[i];
                    double p1z = pointsZ[i];
                    double p2x = pointsX[i + 1 == pointsX.length ? 0 : i + 1];
                    Vector2 closestPoint = ShapeUtil.closestPointOnLine((double)posX, (double)posZ, (double)p1x, (double)p1z, (double)p2x, (double)(p2z = pointsZ[i + 1 == pointsZ.length ? 0 : i + 1]));
                    if (ShapeUtil.distanceBetweenPoints((double)posX, (double)posZ, (double)closestPoint.getX(), (double)closestPoint.getZ()) > renderDistanceBlocks) continue;
                    double dx = p2x - p1x;
                    double dz = p2z - p1z;
                    double distance = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dz, 2.0));
                    double unitX = distance == 0.0 ? 0.0 : dx / distance;
                    double unitZ = distance == 0.0 ? 0.0 : dz / distance;
                    double absUnitX = Math.abs(unitX);
                    double absUnitZ = Math.abs(unitZ);
                    double distanceFromStartX = Math.abs(closestPoint.getX() - p1x);
                    double distanceFromStartZ = Math.abs(closestPoint.getZ() - p1z);
                    long unitsFromStartX = absUnitX == 0.0 ? 0L : (long)(distanceFromStartX / absUnitX);
                    long unitsFromStartZ = absUnitZ == 0.0 ? 0L : (long)(distanceFromStartZ / absUnitZ);
                    double closestPointAdjustedX = p1x + (double)unitsFromStartX * unitX;
                    double closestPointAdjustedZ = p1z + (double)unitsFromStartZ * unitZ;
                    double startX = this.clamp(closestPointAdjustedX - renderDistanceBlocks * unitX, p1x, p2x);
                    double startZ = this.clamp(closestPointAdjustedZ - renderDistanceBlocks * unitZ, p1z, p2z);
                    double stopX = this.clamp(closestPointAdjustedX + renderDistanceBlocks * unitX, p1x, p2x);
                    double stopZ = this.clamp(closestPointAdjustedZ + renderDistanceBlocks * unitZ, p1z, p2z);
                    float texturePosition = 0.0f;
                    double x = startX;
                    double z = startZ;
                    while (true) {
                        double z2;
                        double x2;
                        float textureDistance;
                        double remainingX = stopX - x;
                        double remainingZ = stopZ - z;
                        if (Math.abs(remainingX) <= absUnitX || Math.abs(remainingZ) <= absUnitZ) {
                            float remainingDistance = (float)Math.sqrt(Math.pow(remainingX, 2.0) + Math.pow(remainingZ, 2.0));
                            textureDistance = remainingDistance * 0.5f;
                            x2 = x + remainingX;
                            z2 = z + remainingZ;
                            this.addWall(bufferBuilder, height, posX, posZ, x, z, x2, z2, offset, texturePosition, textureDistance, textureVertical);
                            continue block1;
                        }
                        textureDistance = 0.5f;
                        x2 = x + unitX;
                        z2 = z + unitZ;
                        this.addWall(bufferBuilder, height, posX, posZ, x, z, x2, z2, offset, texturePosition, textureDistance, textureVertical);
                        x += unitX;
                        z += unitZ;
                        texturePosition += 0.5f;
                    }
                }
            } else if (borderShape instanceof EllipseBorderShape) {
                double maxAngle;
                double minAngle;
                EllipseBorderShape ellipse = (EllipseBorderShape)borderShape;
                double centerX = ellipse.getCenterX();
                double centerZ = ellipse.getCenterZ();
                double radiusX = ellipse.getRadiusX();
                double radiusZ = ellipse.getRadiusZ();
                double radius = Math.min(radiusX, radiusZ);
                double angle = Math.acos((2.0 * radius * radius - 1.0) / (2.0 * radius * radius));
                if (radius > renderDistanceBlocks) {
                    double cameraAngle = Math.atan2(radiusX * (posZ - centerZ), radiusZ * (posX - centerX));
                    double cameraAngleAdjusted = Math.floor(cameraAngle / angle) * angle;
                    double arcAngle = renderDistanceBlocks / radius;
                    minAngle = cameraAngleAdjusted - arcAngle;
                    maxAngle = cameraAngleAdjusted + arcAngle;
                } else {
                    minAngle = 0.0;
                    maxAngle = Math.PI * 2;
                }
                float texturePosition = 0.0f;
                double a = minAngle;
                double b = minAngle + angle;
                while (a < maxAngle) {
                    float textureHorizontal;
                    Vector2 pointB;
                    Vector2 pointA = ShapeUtil.pointOnEllipse((double)centerX, (double)centerZ, (double)radiusX, (double)radiusZ, (double)a);
                    if (b >= maxAngle) {
                        pointB = ShapeUtil.pointOnEllipse((double)centerX, (double)centerZ, (double)radiusX, (double)radiusZ, (double)maxAngle);
                        float remainingDistance = (float)ShapeUtil.distanceBetweenPoints((double)pointA.getX(), (double)pointA.getZ(), (double)pointB.getX(), (double)pointB.getZ());
                        textureHorizontal = remainingDistance * 0.5f;
                        this.addWall(bufferBuilder, height, posX, posZ, pointB.getX(), pointB.getZ(), pointA.getX(), pointA.getZ(), offset, 0.0f, textureHorizontal, textureVertical);
                        break;
                    }
                    pointB = ShapeUtil.pointOnEllipse((double)centerX, (double)centerZ, (double)radiusX, (double)radiusZ, (double)b);
                    textureHorizontal = 0.5f;
                    this.addWall(bufferBuilder, height, posX, posZ, pointB.getX(), pointB.getZ(), pointA.getX(), pointA.getZ(), offset, 0.0f, textureHorizontal, textureVertical);
                    a += angle;
                    b += angle;
                }
            }
            if ((meshdata = bufferBuilder.build()) != null) {
                BufferUploader.drawWithShader((MeshData)meshdata);
            }
            RenderSystem.enableCull();
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.depthMask((boolean)true);
        }
        ci.cancel();
    }

    private double clamp(double value, double p1, double p2) {
        double min = Math.min(p1, p2);
        double max = Math.max(p1, p2);
        return Math.max(min, Math.min(max, value));
    }

    private void addWall(BufferBuilder bufferBuilder, double height, double posX, double posZ, double x1, double z1, double x2, double z2, float offset, float texturePosition, float textureHorizontal, float textureVertical) {
        this.addVertex(bufferBuilder, -height, posX, posZ, x1, z1, offset + texturePosition, offset + textureVertical);
        this.addVertex(bufferBuilder, -height, posX, posZ, x2, z2, offset + texturePosition + textureHorizontal, offset + textureVertical);
        this.addVertex(bufferBuilder, height, posX, posZ, x2, z2, offset + texturePosition + textureHorizontal, offset);
        this.addVertex(bufferBuilder, height, posX, posZ, x1, z1, offset + texturePosition, offset);
    }

    private void addVertex(BufferBuilder bufferBuilder, double height, double x1, double z1, double x2, double z2, float u, float v) {
        bufferBuilder.addVertex((float)(x2 - x1), (float)height, (float)(z2 - z1)).setUv(u, v);
    }
}

