/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder.integration;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.platform.util.Vector2;
import org.popcraft.chunky.shape.AbstractEllipse;
import org.popcraft.chunky.shape.AbstractPolygon;
import org.popcraft.chunky.shape.Circle;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunkyborder.integration.AbstractMapIntegration;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.LayerProvider;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.Registry;
import xyz.jpenilla.squaremap.api.SimpleLayerProvider;
import xyz.jpenilla.squaremap.api.Squaremap;
import xyz.jpenilla.squaremap.api.WorldIdentifier;
import xyz.jpenilla.squaremap.api.marker.Marker;
import xyz.jpenilla.squaremap.api.marker.MarkerOptions;

public class SquaremapIntegration
extends AbstractMapIntegration {
    private static final Key WORLDBORDER_KEY = Key.of((String)"squaremap-worldborder");
    private static final Key CHUNKY_KEY = Key.of((String)"chunky");
    private final Squaremap squaremap;
    private final Map<String, LayerProvider> defaultProviders = new HashMap<String, LayerProvider>();
    private boolean hideByDefault;
    private int priority;

    public SquaremapIntegration(Squaremap squaremap) {
        this.squaremap = squaremap;
    }

    @Override
    public void addShapeMarker(World world, Shape shape) {
        this.getWorldIdentifier(world).flatMap(arg_0 -> ((Squaremap)this.squaremap).getWorldIfEnabled(arg_0)).ifPresent(squaremapWorld -> {
            Object marker;
            Registry layerRegistry = squaremapWorld.layerRegistry();
            if (layerRegistry.hasEntry(WORLDBORDER_KEY)) {
                this.defaultProviders.put(squaremapWorld.identifier().asString(), (LayerProvider)layerRegistry.get(WORLDBORDER_KEY));
                layerRegistry.unregister(WORLDBORDER_KEY);
            }
            if (!layerRegistry.hasEntry(CHUNKY_KEY)) {
                layerRegistry.register(CHUNKY_KEY, (Object)SimpleLayerProvider.builder((String)this.label).defaultHidden(this.hideByDefault).layerPriority(1).zIndex(this.priority).build());
            }
            SimpleLayerProvider chunkyLayerProvider = (SimpleLayerProvider)layerRegistry.get(CHUNKY_KEY);
            chunkyLayerProvider.clearMarkers();
            if (shape instanceof AbstractPolygon) {
                AbstractPolygon polygon = (AbstractPolygon)shape;
                List points = polygon.points().stream().map(point -> Point.of((double)point.getX(), (double)point.getZ())).collect(Collectors.toList());
                Vector2 lastPoint = (Vector2)polygon.points().get(0);
                points.add(Point.of((double)lastPoint.getX(), (double)lastPoint.getZ()));
                marker = Marker.polyline(points);
            } else if (shape instanceof AbstractEllipse) {
                AbstractEllipse ellipse = (AbstractEllipse)shape;
                Vector2 center = ellipse.center();
                Vector2 radii = ellipse.radii();
                Point centerPoint = Point.of((double)center.getX(), (double)center.getZ());
                marker = ellipse instanceof Circle ? Marker.circle((Point)centerPoint, (double)radii.getX()) : this.ellipse(centerPoint, radii.getX(), radii.getZ());
            } else {
                return;
            }
            MarkerOptions markerOptions = MarkerOptions.builder().stroke(true).strokeColor(new Color(this.color)).strokeWeight(this.weight).fill(false).clickTooltip(this.label).build();
            marker.markerOptions(markerOptions);
            chunkyLayerProvider.addMarker(CHUNKY_KEY, (Marker)marker);
        });
    }

    @Override
    public void removeShapeMarker(World world) {
        this.getWorldIdentifier(world).flatMap(arg_0 -> ((Squaremap)this.squaremap).getWorldIfEnabled(arg_0)).ifPresent(this::unregisterLayer);
    }

    @Override
    public void removeAllShapeMarkers() {
        this.squaremap.mapWorlds().forEach(this::unregisterLayer);
    }

    private void unregisterLayer(MapWorld mapWorld) {
        LayerProvider defaultProvider;
        Registry layerRegistry = mapWorld.layerRegistry();
        if (!layerRegistry.hasEntry(WORLDBORDER_KEY) && (defaultProvider = this.defaultProviders.get(mapWorld.identifier().asString())) != null) {
            layerRegistry.register(WORLDBORDER_KEY, (Object)defaultProvider);
        }
        if (layerRegistry.hasEntry(CHUNKY_KEY)) {
            ((SimpleLayerProvider)layerRegistry.get(CHUNKY_KEY)).clearMarkers();
            layerRegistry.unregister(CHUNKY_KEY);
        }
    }

    @Override
    public void setOptions(String label, String color, boolean hideByDefault, int priority, int weight) {
        super.setOptions(label, color, hideByDefault, priority, weight);
        this.hideByDefault = hideByDefault;
        this.priority = priority;
    }

    private Marker ellipse(Point center, double radiusX, double radiusZ) {
        int numPoints = 360;
        Point[] points = new Point[361];
        double segmentAngle = Math.PI / 180;
        for (int i = 0; i < 360; ++i) {
            double pointX = center.x() + Math.sin(Math.PI / 180 * (double)i) * radiusX;
            double pointZ = center.z() + Math.cos(Math.PI / 180 * (double)i) * radiusZ;
            points[i] = Point.of((double)pointX, (double)pointZ);
        }
        points[360] = Point.of((double)center.x(), (double)(center.z() + radiusZ));
        return Marker.polyline((Point[])points);
    }

    private Optional<WorldIdentifier> getWorldIdentifier(World world) {
        try {
            return Optional.of(WorldIdentifier.parse((String)world.getKey()));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }
}

