/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.neoforge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import me.chrr.camerapture.net.NetCodec;
import me.chrr.camerapture.net.NetworkAdapter;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NeoForgeNetworkAdapter
implements NetworkAdapter {
    private final Map<Class<?>, ServerPacketType<?>> serverPackets = new HashMap();
    private final Map<Class<?>, ClientPacketType<?>> clientPackets = new HashMap();

    public <P> void registerServerBound(PayloadRegistrar registrar, Class<P> clazz, NetCodec<P> netCodec) {
        ClientPacketType type = new ClientPacketType(netCodec, new ArrayList());
        this.clientPackets.put(clazz, type);
        StreamCodec codec = ByteBufCodecs.fromCodec(netCodec.codec());
        registrar.playToServer(new CustomPacketPayload.Type(netCodec.id()), StreamCodec.composite((StreamCodec)codec, PacketPayload::packet, p -> new PacketPayload<Object>(netCodec.id(), p)), (payload, context) -> type.handlers().forEach(handler -> handler.accept(payload.packet, (ServerPlayer)context.player())));
    }

    public <P> void registerClientBound(PayloadRegistrar registrar, Class<P> clazz, NetCodec<P> netCodec) {
        ServerPacketType type = new ServerPacketType(netCodec, new ArrayList());
        this.serverPackets.put(clazz, type);
        StreamCodec codec = ByteBufCodecs.fromCodec(netCodec.codec());
        registrar.playToClient(new CustomPacketPayload.Type(netCodec.id()), StreamCodec.composite((StreamCodec)codec, PacketPayload::packet, p -> new PacketPayload<Object>(netCodec.id(), p)), (payload, context) -> type.handlers().forEach(handler -> handler.accept(payload.packet)));
    }

    @Override
    public <P> void sendToClient(ServerPlayer player, P packet) {
        ServerPacketType<?> type = this.getServerPacketType(packet.getClass());
        PacketDistributor.sendToPlayer((ServerPlayer)player, new PacketPayload<P>(type.netCodec().id(), packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <P> void onReceiveFromClient(Class<P> clazz, BiConsumer<P, ServerPlayer> handler) {
        this.getClientPacketType(clazz).handlers().add(handler);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <P> void sendToServer(P packet) {
        ClientPacketType<?> type = this.getClientPacketType(packet.getClass());
        PacketDistributor.sendToServer(new PacketPayload<P>(type.netCodec().id(), packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <P> void onReceiveFromServer(Class<P> clazz, Consumer<P> handler) {
        this.getServerPacketType(clazz).handlers().add(handler);
    }

    private <P> ServerPacketType<P> getServerPacketType(Class<P> clazz) {
        ServerPacketType<?> type = this.serverPackets.get(clazz);
        return type;
    }

    private <P> ClientPacketType<P> getClientPacketType(Class<P> clazz) {
        ClientPacketType<?> type = this.clientPackets.get(clazz);
        return type;
    }

    private record ClientPacketType<P>(NetCodec<P> netCodec, List<BiConsumer<P, ServerPlayer>> handlers) {
    }

    private record ServerPacketType<P>(NetCodec<P> netCodec, List<Consumer<P>> handlers) {
    }

    private record PacketPayload<P>(ResourceLocation id, P packet) implements CustomPacketPayload
    {
        public CustomPacketPayload.Type<PacketPayload<P>> type() {
            return new CustomPacketPayload.Type(this.id);
        }
    }
}

