/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.entity.PictureFrameEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class PictureItem
extends Item {
    public static final ResourceLocation ID = Camerapture.id("picture");
    public static final ResourceKey<Item> KEY = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ID);
    private static final SimpleDateFormat SDF = new SimpleDateFormat("MMM d, yyyy 'at' HH:mm");

    public PictureItem() {
        super(new Item.Properties());
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        if (!user.isShiftKeyDown()) {
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null || !player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        Level world = context.getLevel();
        Direction facing = context.getClickedFace();
        BlockPos pos = context.getClickedPos().relative(facing);
        ItemStack itemStack = context.getItemInHand();
        if (facing.getAxis().isVertical() || !player.mayUseItemAt(pos, facing, itemStack)) {
            return InteractionResult.PASS;
        }
        PictureFrameEntity pictureFrameEntity = new PictureFrameEntity(world, pos, facing);
        if (!pictureFrameEntity.canStayAttached()) {
            return InteractionResult.PASS;
        }
        CustomData nbtComponent = (CustomData)itemStack.getOrDefault(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY);
        if (!nbtComponent.isEmpty()) {
            EntityType.updateCustomEntityTag((Level)world, (Player)player, (Entity)pictureFrameEntity, (CustomData)nbtComponent);
        }
        pictureFrameEntity.setItemStack(itemStack.copyWithCount(1));
        if (!world.isClientSide) {
            pictureFrameEntity.onPlace();
            world.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, pictureFrameEntity.position());
            world.addFreshEntity((Entity)pictureFrameEntity);
        }
        itemStack.shrink(1);
        return InteractionResult.SUCCESS;
    }

    public static ItemStack create(String creator, UUID uuid) {
        ItemStack stack = new ItemStack((ItemLike)Camerapture.PICTURE, 1);
        stack.set(Camerapture.PICTURE_DATA, (Object)new PictureData(uuid, creator, System.currentTimeMillis()));
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        PictureItem.getTooltip(tooltip::add, stack);
    }

    public static void getTooltip(Consumer<Component> textConsumer, ItemStack stack) {
        PictureData data = PictureItem.getPictureData(stack);
        if (data == null) {
            return;
        }
        textConsumer.accept((Component)Component.translatable((String)"item.camerapture.picture.creator_tooltip", (Object[])new Object[]{Component.literal((String)data.creator).withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.DARK_GRAY));
        String timestamp = SDF.format(new Date(data.timestamp));
        textConsumer.accept((Component)Component.translatable((String)"item.camerapture.picture.timestamp_tooltip", (Object[])new Object[]{Component.literal((String)timestamp).withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.DARK_GRAY));
    }

    @Nullable
    public static PictureData getPictureData(ItemStack stack) {
        return (PictureData)stack.get(Camerapture.PICTURE_DATA);
    }

    public record PictureData(UUID id, String creator, long timestamp) {
        public static Codec<PictureData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.AUTHLIB_CODEC.fieldOf("id").forGetter(component -> component.id), (App)Codec.STRING.fieldOf("creator").forGetter(component -> component.creator), (App)Codec.LONG.fieldOf("timestamp").forGetter(component -> component.timestamp)).apply((Applicative)instance, PictureData::new));
        public static StreamCodec<ByteBuf, PictureData> PACKET_CODEC = ByteBufCodecs.fromCodec(CODEC);
    }
}

