/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.components.NamedPositions;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.misc.CameraRedstoneModuleState;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.MountCamera;
import net.geforcemods.securitycraft.network.server.RemoveCameraTag;
import net.geforcemods.securitycraft.screen.components.SmallButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;

public class CameraMonitorScreen
extends Screen {
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/gui/container/blank.png");
    private final Component selectCameras = Utils.localize("gui.securitycraft:monitor.selectCameras", new Object[0]);
    private Inventory playerInventory;
    private ItemStack cameraMonitor;
    private Button[] cameraButtons = new Button[10];
    private CameraRedstoneModuleState[] redstoneModuleStates = new CameraRedstoneModuleState[10];
    private int xSize = 176;
    private int ySize = 166;
    private int leftPos;
    private int topPos;
    private int page = 1;

    public CameraMonitorScreen(Inventory inventory, ItemStack stack) {
        super((Component)Component.translatable((String)((CameraMonitorItem)((Object)SCContent.CAMERA_MONITOR.get())).getDescriptionId()));
        this.playerInventory = inventory;
        this.cameraMonitor = stack;
    }

    public CameraMonitorScreen(Inventory inventory, ItemStack stack, int page) {
        this(inventory, stack);
        this.page = page;
    }

    public void init() {
        super.init();
        this.leftPos = (this.width - this.xSize) / 2;
        this.topPos = (this.height - this.ySize) / 2;
        Button prevPageButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 - 25, this.height / 2 + 57, 20, 20, (Component)Component.literal((String)"<"), b -> this.minecraft.setScreen((Screen)new CameraMonitorScreen(this.playerInventory, this.cameraMonitor, this.page - 1)), Button.DEFAULT_NARRATION));
        Button nextPageButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 + 5, this.height / 2 + 57, 20, 20, (Component)Component.literal((String)">"), b -> this.minecraft.setScreen((Screen)new CameraMonitorScreen(this.playerInventory, this.cameraMonitor, this.page + 1)), Button.DEFAULT_NARRATION));
        NamedPositions cameras = (NamedPositions)this.cameraMonitor.getOrDefault(SCContent.BOUND_CAMERAS, (Object)CameraMonitorItem.DEFAULT_NAMED_POSITIONS);
        List<NamedPositions.Entry> views = cameras.positions();
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        for (int i = 0; i < 10; ++i) {
            int buttonId = i + 1;
            int camID = buttonId + (this.page - 1) * 10;
            int x = this.leftPos + 18 + i % 5 * 30;
            int y = this.topPos + 30 + i / 5 * 55;
            int aboveCameraButton = y - 8;
            NamedPositions.Entry view = views.get(camID - 1);
            Button cameraButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(x, y, 20, 20, (Component)Component.empty(), button -> this.cameraButtonClicked(button, view.globalPos()), Button.DEFAULT_NARRATION));
            Button unbindButton = (Button)this.addRenderableWidget((GuiEventListener)SmallButton.createWithX(x + 19, aboveCameraButton, button -> this.unbindButtonClicked(button, view.globalPos(), camID)));
            this.cameraButtons[i] = cameraButton;
            cameraButton.setMessage((Component)cameraButton.getMessage().plainCopy().append((Component)Component.literal((String)("" + camID))));
            if (view != null) {
                SecurityCameraBlockEntity cameraEntity;
                GlobalPos globalPos = view.globalPos();
                BlockPos pos = globalPos.pos();
                BlockEntity blockEntity = level.getBlockEntity(pos);
                SecurityCameraBlockEntity cameraBe = blockEntity instanceof SecurityCameraBlockEntity ? (cameraEntity = (SecurityCameraBlockEntity)blockEntity) : null;
                String cameraName = view.name().orElse(null);
                if (cameraBe != null) {
                    BlockState state = level.getBlockState(pos);
                    if (cameraBe.isDisabled() || cameraBe.isShutDown()) {
                        cameraButton.setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0])));
                        cameraButton.active = false;
                    } else if (cameraName == null && cameraBe.hasCustomName()) {
                        cameraName = cameraBe.getCustomName().getString();
                    }
                    this.redstoneModuleStates[i] = state.getSignal((BlockGetter)level, pos, (Direction)state.getValue((Property)SecurityCameraBlock.FACING)) == 0 ? (!cameraBe.isModuleEnabled(ModuleType.REDSTONE) ? CameraRedstoneModuleState.NOT_INSTALLED : CameraRedstoneModuleState.DEACTIVATED) : CameraRedstoneModuleState.ACTIVATED;
                }
                if (cameraButton.active && cameraName != null) {
                    cameraButton.setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:monitor.cameraName", cameraName)));
                }
                if (!player.isCreative()) continue;
                Button tpButton = (Button)this.addRenderableWidget((GuiEventListener)SmallButton.create(x, aboveCameraButton, (Component)Component.empty(), b -> {
                    player.connection.sendUnsignedCommand(String.format("execute in %s run tp %s %s %s", globalPos.dimension().location(), pos.getX(), pos.getY(), pos.getZ()));
                    this.minecraft.setScreen(null);
                }));
                tpButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"chat.coordinates.tooltip")));
                continue;
            }
            cameraButton.active = false;
            unbindButton.active = false;
        }
        prevPageButton.active = this.page != 1;
        nextPageButton.active = this.page != 3;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        for (int i = 0; i < 10; ++i) {
            Button button = this.cameraButtons[i];
            CameraRedstoneModuleState redstoneModuleState = this.redstoneModuleStates[i];
            if (redstoneModuleState == null) continue;
            redstoneModuleState.render(guiGraphics, button.getX() + 4, button.getY() + 25);
        }
        guiGraphics.drawString(this.font, this.selectCameras, this.leftPos + this.xSize / 2 - this.font.width((FormattedText)this.selectCameras) / 2, this.topPos + 6, 0x404040, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.xSize, this.ySize);
    }

    private void cameraButtonClicked(Button button, GlobalPos camera) {
        if (camera != null) {
            SecurityCameraBlockEntity cameraEntity;
            BlockPos cameraPos = camera.pos();
            BlockEntity blockEntity = this.minecraft.level.getBlockEntity(cameraPos);
            if (blockEntity instanceof SecurityCameraBlockEntity && ((cameraEntity = (SecurityCameraBlockEntity)blockEntity).isDisabled() || cameraEntity.isShutDown())) {
                button.active = false;
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new MountCamera(cameraPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Minecraft.getInstance().player.closeContainer();
        }
    }

    private void unbindButtonClicked(Button button, GlobalPos camera, int camID) {
        if (camera != null) {
            int i = (camID - 1) % 10;
            Button cameraButton = this.cameraButtons[i];
            PacketDistributor.sendToServer((CustomPacketPayload)new RemoveCameraTag(camera), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ((NamedPositions)this.cameraMonitor.getOrDefault(SCContent.BOUND_CAMERAS, (Object)CameraMonitorItem.DEFAULT_NAMED_POSITIONS)).remove(SCContent.BOUND_CAMERAS, this.cameraMonitor, camera);
            button.active = false;
            cameraButton.active = false;
            cameraButton.setTooltip(null);
            this.redstoneModuleStates[i] = null;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

