/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.vertex.Tesselator;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.inventory.BlockChangeDetectorMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.ClearChangeDetectorServer;
import net.geforcemods.securitycraft.network.server.SyncBlockChangeDetector;
import net.geforcemods.securitycraft.screen.components.CallbackCheckbox;
import net.geforcemods.securitycraft.screen.components.CollapsibleTextList;
import net.geforcemods.securitycraft.screen.components.ColorChooser;
import net.geforcemods.securitycraft.screen.components.ColorChooserButton;
import net.geforcemods.securitycraft.screen.components.IToggleableButton;
import net.geforcemods.securitycraft.screen.components.SmallButton;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.util.IHasExtraAreas;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.client.gui.widget.ScrollPanel;
import net.neoforged.neoforge.network.PacketDistributor;

public class BlockChangeDetectorScreen
extends AbstractContainerScreen<BlockChangeDetectorMenu>
implements ContainerListener,
IHasExtraAreas {
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/gui/container/block_change_detector.png");
    private BlockChangeDetectorBlockEntity be;
    private ChangeEntryList changeEntryList;
    private TextHoverChecker smartModuleHoverChecker;
    private CallbackCheckbox showAllCheckbox;
    private ColorChooser colorChooser;
    private final BlockChangeDetectorBlockEntity.DetectionMode previousMode;
    private final boolean wasShowingHighlights;
    private final int previousColor;

    public BlockChangeDetectorScreen(BlockChangeDetectorMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        menu.addSlotListener(this);
        this.be = (BlockChangeDetectorBlockEntity)menu.be;
        this.imageWidth = 200;
        this.imageHeight = 256;
        this.previousMode = this.be.getMode();
        this.wasShowingHighlights = this.be.isShowingHighlights();
        this.previousColor = this.be.getColor();
    }

    protected void init() {
        super.init();
        Button clearButton = (Button)this.addRenderableWidget((GuiEventListener)SmallButton.createWithX(this.leftPos + 4, this.topPos + 4, b -> {
            this.changeEntryList.allEntries.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
            this.changeEntryList.allEntries.clear();
            this.changeEntryList.filteredEntries.clear();
            this.be.getEntries().clear();
            this.be.setChanged();
            PacketDistributor.sendToServer((CustomPacketPayload)new ClearChangeDetectorServer(this.be.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }));
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        boolean isOwner = this.be.isOwnedBy((Entity)this.minecraft.player);
        int settingsX = this.leftPos + 173;
        Button modeButton = (Button)this.addRenderableWidget((GuiEventListener)new ModeButton(this, settingsX, this.topPos + 19, 20, 20, this.be.getMode().ordinal(), BlockChangeDetectorBlockEntity.DetectionMode.values().length, b -> {
            this.be.setMode(BlockChangeDetectorBlockEntity.DetectionMode.values()[((ModeButton)b).getCurrentIndex()]);
            b.setTooltip(Tooltip.create((Component)Utils.localize(this.be.getMode().getDescriptionId(), new Object[0])));
            this.changeEntryList.updateFilteredEntries();
            this.be.updateFilteredEntries();
        }));
        this.showAllCheckbox = (CallbackCheckbox)this.addRenderableWidget((GuiEventListener)new CallbackCheckbox(settingsX, this.topPos + 65, 20, 20, (Component)Component.empty(), false, isSelected -> this.changeEntryList.updateFilteredEntries(), 0));
        CallbackCheckbox highlightInWorldCheckbox = (CallbackCheckbox)this.addRenderableWidget((GuiEventListener)new CallbackCheckbox(settingsX, this.topPos + 90, 20, 20, (Component)Component.empty(), this.be.isShowingHighlights(), this.be::showHighlights, 0));
        this.colorChooser = (ColorChooser)this.addRenderableWidget(new ColorChooser((Component)Component.empty(), settingsX, this.topPos + 135, this.previousColor){

            @Override
            public void onColorChange() {
                BlockChangeDetectorScreen.this.be.setColor(this.getRGBColor());
            }
        });
        this.colorChooser.init(this.minecraft, this.width, this.height);
        Button colorChooserButton = (Button)this.addRenderableWidget((GuiEventListener)new ColorChooserButton(settingsX, this.topPos + 115, 20, 20, this.colorChooser));
        clearButton.setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:editModule.clear", new Object[0])));
        modeButton.setTooltip(Tooltip.create((Component)Utils.localize(this.be.getMode().getDescriptionId(), new Object[0])));
        this.showAllCheckbox.setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:block_change_detector.show_all_checkbox", new Object[0])));
        highlightInWorldCheckbox.setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:block_change_detector.highlight_in_world_checkbox", new Object[0])));
        colorChooserButton.setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:choose_outline_color_tooltip", new Object[0])));
        this.smartModuleHoverChecker = isOwner ? new TextHoverChecker(this.topPos + 44, this.topPos + 60, settingsX + 1, this.leftPos + 191, (Component)Utils.localize("gui.securitycraft:block_change_detector.smart_module_hint", new Object[0])) : null;
        this.changeEntryList = (ChangeEntryList)this.addRenderableWidget((GuiEventListener)new ChangeEntryList(this.minecraft, 160, 150, this.topPos + 20, this.leftPos + 8));
        modeButton.active = colorChooserButton.active = isOwner;
        clearButton.active = colorChooserButton.active;
        for (BlockChangeDetectorBlockEntity.ChangeEntry entry : this.be.getEntries()) {
            Object stateString = !entry.state().getProperties().isEmpty() ? "[" + entry.state().toString().split("\\[")[1].replace(",", ", ") : "";
            List list = List.of(entry.player(), entry.uuid(), entry.action(), Utils.getFormattedCoordinates(entry.pos()).getString(), stateString, dateFormat.format(new Date(entry.timestamp()))).stream().map(rec$ -> rec$.toString()).filter(s -> !s.isEmpty()).map(Component::literal).collect(Collectors.toList());
            this.changeEntryList.addEntry((ContentSavingCollapsileTextList)this.addWidget((GuiEventListener)new ContentSavingCollapsileTextList(this, 0, 0, 154, (Component)Utils.localize(entry.state().getBlock().getDescriptionId(), new Object[0]), list, b -> this.changeEntryList.setOpen((ContentSavingCollapsileTextList)b), this.changeEntryList::isHovered, entry)));
        }
        this.changeEntryList.updateFilteredEntries();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.imageWidth / 2 - this.font.width((FormattedText)this.title) / 2, 6, 0x404040, false);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.smartModuleHoverChecker != null && this.smartModuleHoverChecker.checkHover(mouseX, mouseY) && !this.be.isModuleEnabled(ModuleType.SMART)) {
            guiGraphics.renderComponentTooltip(this.font, this.smartModuleHoverChecker.getLines(), mouseX, mouseY);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void containerTick() {
        if (this.colorChooser != null) {
            this.colorChooser.tick();
        }
        if (this.changeEntryList != null) {
            this.changeEntryList.tick();
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.changeEntryList != null) {
            this.changeEntryList.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.changeEntryList != null) {
            this.changeEntryList.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.changeEntryList != null) {
            this.changeEntryList.mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.changeEntryList != null) {
            this.changeEntryList.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.colorChooser != null) {
            this.colorChooser.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.colorChooser != null) {
            this.colorChooser.keyPressed(keyCode, scanCode, modifiers);
            if (!this.colorChooser.getRgbHexBox().isFocused()) {
                return super.keyPressed(keyCode, scanCode, modifiers);
            }
        }
        return true;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.colorChooser != null && this.colorChooser.charTyped(codePoint, modifiers)) {
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    public void onClose() {
        super.onClose();
        BlockChangeDetectorBlockEntity.DetectionMode currentMode = this.be.getMode();
        boolean isShowingHighlights = this.be.isShowingHighlights();
        int currentColor = this.be.getColor();
        if (this.previousMode != currentMode || this.wasShowingHighlights != isShowingHighlights || this.previousColor != currentColor) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncBlockChangeDetector(this.be.getBlockPos(), currentMode, isShowingHighlights, currentColor), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.be.updateFilteredEntries();
    }

    public void slotChanged(AbstractContainerMenu menu, int slotIndex, ItemStack stack) {
        if (slotIndex == 0 && this.changeEntryList != null) {
            this.changeEntryList.updateFilteredEntries();
            this.be.updateFilteredEntries();
        }
    }

    public void dataChanged(AbstractContainerMenu menu, int slotIndex, int value) {
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        if (this.colorChooser != null) {
            return this.colorChooser.getGuiExtraAreas();
        }
        return List.of();
    }

    class ModeButton
    extends Button
    implements IToggleableButton {
        private final ItemStack ironPickaxe = new ItemStack((ItemLike)Items.IRON_PICKAXE);
        private final ItemStack grassBlock = new ItemStack((ItemLike)Blocks.GRASS_BLOCK);
        private final int toggleCount;
        private int currentIndex = 0;

        public ModeButton(BlockChangeDetectorScreen this$0, int xPos, int yPos, int width, int height, int initialIndex, int toggleCount, Button.OnPress onPress) {
            super(xPos, yPos, width, height, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
            this.toggleCount = toggleCount;
            this.currentIndex = initialIndex;
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
            if (this.currentIndex == BlockChangeDetectorBlockEntity.DetectionMode.BREAK.ordinal()) {
                guiGraphics.renderItem(this.ironPickaxe, this.getX() + 2, this.getY() + 2);
            } else if (this.currentIndex == BlockChangeDetectorBlockEntity.DetectionMode.PLACE.ordinal()) {
                guiGraphics.renderItem(this.grassBlock, this.getX() + 2, this.getY() + 2);
            } else if (this.currentIndex == BlockChangeDetectorBlockEntity.DetectionMode.BOTH.ordinal()) {
                guiGraphics.renderItem(this.grassBlock, this.getX() + 2, this.getY() + 2, 0, -100);
                guiGraphics.renderItem(this.ironPickaxe, this.getX() + 2, this.getY() + 2);
            }
        }

        public void onClick(double mouseX, double mouseY) {
            if (Screen.hasShiftDown()) {
                this.setCurrentIndex(this.currentIndex - 1);
            } else {
                this.setCurrentIndex(this.currentIndex + 1);
            }
            super.onClick(mouseX, mouseY);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            this.setCurrentIndex(this.currentIndex - (int)Math.signum(scrollY));
            this.onPress.onPress((Button)this);
            return true;
        }

        @Override
        public int getCurrentIndex() {
            return this.currentIndex;
        }

        @Override
        public void setCurrentIndex(int newIndex) {
            this.currentIndex = Math.floorMod(newIndex, this.toggleCount);
        }
    }

    class ChangeEntryList
    extends ScrollPanel {
        private static final int SLOT_HEIGHT = 12;
        private List<ContentSavingCollapsileTextList> allEntries;
        private List<ContentSavingCollapsileTextList> filteredEntries;
        private ContentSavingCollapsileTextList currentlyOpen;
        private int contentHeight;

        public ChangeEntryList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left, 4, 6);
            this.allEntries = new ArrayList<ContentSavingCollapsileTextList>();
            this.filteredEntries = new ArrayList<ContentSavingCollapsileTextList>();
            this.currentlyOpen = null;
            this.contentHeight = 0;
        }

        protected int getContentHeight() {
            return this.contentHeight;
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            int i;
            int height = 0;
            for (i = 0; i < this.filteredEntries.size(); ++i) {
                ContentSavingCollapsileTextList entry = this.filteredEntries.get(i);
                entry.setY(this.top + height - (int)this.scrollDistance);
                entry.visible = entry.getY() + entry.getHeight() > this.top && entry.getY() < this.bottom;
                height += entry.getHeight();
            }
            this.applyScrollLimits();
            super.render(guiGraphics, mouseX, mouseY, partialTicks);
            for (i = 0; i < this.filteredEntries.size(); ++i) {
                this.filteredEntries.get(i).renderLongMessageTooltip(guiGraphics, BlockChangeDetectorScreen.this.font);
            }
        }

        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tesselator, int mouseX, int mouseY) {
            for (int i = 0; i < this.filteredEntries.size(); ++i) {
                this.filteredEntries.get(i).render(guiGraphics, mouseX, mouseY, 0.0f);
            }
        }

        public void tick() {
            this.filteredEntries.forEach(CollapsibleTextList::tick);
        }

        public void addEntry(ContentSavingCollapsileTextList entry) {
            entry.setWidth(154);
            entry.setHeight(12);
            entry.setX(this.left);
            entry.setY(this.top + 12 * this.allEntries.size());
            this.allEntries.add(entry);
        }

        public void setOpen(ContentSavingCollapsileTextList newOpenedTextList) {
            if (this.currentlyOpen == null) {
                this.currentlyOpen = newOpenedTextList;
            } else if (this.currentlyOpen == newOpenedTextList) {
                this.currentlyOpen = null;
            } else {
                this.currentlyOpen.switchOpenStatus();
                this.currentlyOpen = newOpenedTextList;
            }
            this.recalculateContentHeight();
        }

        public boolean isHovered(int mouseX, int mouseY) {
            return mouseX >= this.left && mouseY >= this.top && mouseX < this.right && mouseY < this.bottom;
        }

        private void applyScrollLimits() {
            int maxScroll = this.getContentHeight() - (this.height - this.border);
            if (maxScroll < 0) {
                maxScroll /= 2;
            }
            if (this.scrollDistance > (float)maxScroll) {
                this.scrollDistance = maxScroll;
            }
            if (this.scrollDistance < 0.0f) {
                this.scrollDistance = 0.0f;
            }
        }

        public void updateFilteredEntries() {
            this.allEntries.forEach(e -> {
                e.active = false;
            });
            this.filteredEntries = !BlockChangeDetectorScreen.this.showAllCheckbox.selected() ? new ArrayList<ContentSavingCollapsileTextList>(this.allEntries.stream().filter(e -> BlockChangeDetectorScreen.this.be.isEntryShown(e.getChangeEntry())).toList()) : new ArrayList<ContentSavingCollapsileTextList>(this.allEntries);
            this.filteredEntries.forEach(e -> {
                e.active = true;
            });
            this.recalculateContentHeight();
        }

        public void recalculateContentHeight() {
            int height = this.filteredEntries.stream().reduce(0, (accumulated, ctl) -> accumulated + ctl.getMaximumHeight(), (identity, accumulated) -> identity + accumulated);
            if (height < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            this.contentHeight = height;
            if (this.currentlyOpen != null) {
                this.scrollDistance = 12 * this.filteredEntries.indexOf((Object)this.currentlyOpen);
            }
            this.applyScrollLimits();
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (mouseY < (double)this.top || mouseY > (double)this.bottom) {
                return false;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.getContentHeight() < this.height) {
                return false;
            }
            return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            if (this.getContentHeight() < this.height) {
                return false;
            }
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void updateNarration(NarrationElementOutput narrationElementOutput) {
        }
    }

    class ContentSavingCollapsileTextList
    extends CollapsibleTextList {
        private final BlockChangeDetectorBlockEntity.ChangeEntry changeEntry;

        public ContentSavingCollapsileTextList(BlockChangeDetectorScreen this$0, int xPos, int yPos, int width, Component displayString, List<? extends Component> textLines, Button.OnPress onPress, BiPredicate<Integer, Integer> extraHoverCheck, BlockChangeDetectorBlockEntity.ChangeEntry changeEntry) {
            super(xPos, yPos, width, displayString, textLines, onPress, extraHoverCheck);
            this.changeEntry = changeEntry;
        }

        public BlockChangeDetectorBlockEntity.ChangeEntry getChangeEntry() {
            return this.changeEntry;
        }
    }
}

