/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.SonicSecuritySystemModel;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class SonicSecuritySystemRenderer
implements BlockEntityRenderer<SonicSecuritySystemBlockEntity> {
    private static final Quaternionf POSITIVE_X_180 = Axis.XP.rotationDegrees(180.0f);
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/block/sonic_security_system.png");
    private static final Component RECORDING_TEXT = Utils.localize("gui.securitycraft:sonic_security_system.recording", new Object[0]);
    private static final Component LISTENING_TEXT = Utils.localize("gui.securitycraft:sonic_security_system.listening", new Object[0]);
    private final SonicSecuritySystemModel model;

    public SonicSecuritySystemRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new SonicSecuritySystemModel(ctx.bakeLayer(ClientHandler.SONIC_SECURITY_SYSTEM_LOCATION));
    }

    public void render(SonicSecuritySystemBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        boolean recording = be.isRecording();
        ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.tryRenderDelegate(be, partialTicks, pose, buffer, packedLight, packedOverlay);
        pose.translate(0.5, 1.5, 0.5);
        if (recording || be.isListening() && !be.isShutDown()) {
            Component text = recording ? RECORDING_TEXT : LISTENING_TEXT;
            float f1 = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
            int j = (int)(f1 * 255.0f) << 24;
            Font fontRenderer = Minecraft.getInstance().font;
            float halfWidth = -fontRenderer.width((FormattedText)text) / 2;
            pose.pushPose();
            pose.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
            pose.scale(-0.025f, -0.025f, 0.025f);
            Matrix4f positionMatrix = pose.last().pose();
            RenderSystem.disableCull();
            fontRenderer.drawInBatch(text, halfWidth, 0.0f, 0xFFFFFF, false, positionMatrix, buffer, Font.DisplayMode.SEE_THROUGH, j, packedLight);
            fontRenderer.drawInBatch(text, halfWidth, 0.0f, -1, false, positionMatrix, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
            RenderSystem.enableCull();
            pose.popPose();
        }
        if (!be.isModuleEnabled(ModuleType.DISGUISE)) {
            pose.mulPose(POSITIVE_X_180);
            this.model.setRadarRotation(Mth.lerp((float)partialTicks, (float)be.getOriginalRadarRotationDegrees(), (float)be.getRadarRotationDegrees()));
            this.model.renderToBuffer(pose, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)TEXTURE)), packedLight, OverlayTexture.NO_OVERLAY, -1);
        }
    }
}

