/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.recipe;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.components.KeycardData;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class LimitedUseKeycardRecipe
extends CustomRecipe {
    public LimitedUseKeycardRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    public boolean matches(CraftingInput inv, Level level) {
        boolean hasNormalKeycard = false;
        boolean hasLimitedUseKeycard = false;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            Item item = stack.getItem();
            if (item instanceof KeycardItem) {
                if (item != SCContent.LIMITED_USE_KEYCARD.get()) {
                    if (hasNormalKeycard || ((KeycardData)stack.getOrDefault(SCContent.KEYCARD_DATA, (Object)KeycardData.DEFAULT)).limited()) {
                        return false;
                    }
                    hasNormalKeycard = true;
                    continue;
                }
                if (hasLimitedUseKeycard) {
                    return false;
                }
                hasLimitedUseKeycard = true;
                continue;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return hasNormalKeycard && hasLimitedUseKeycard;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider lookupProvider) {
        ItemStack keycard = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            Item item = stack.getItem();
            if (!(item instanceof KeycardItem) || item == SCContent.LIMITED_USE_KEYCARD.get()) continue;
            keycard = stack.copy();
            break;
        }
        if (keycard.isEmpty()) {
            return ItemStack.EMPTY;
        }
        keycard.update(SCContent.KEYCARD_DATA, (Object)KeycardData.DEFAULT, data -> data.setLimitedAndUsesLeft(true, 0));
        keycard.setCount(2);
        return keycard;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SCContent.LIMITED_USE_KEYCARD_RECIPE_SERIALIZER.get();
    }
}

