/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.blocks.BlockPocketManagerBlock;
import net.geforcemods.securitycraft.network.client.BlockPocketManagerFailedActivation;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ToggleBlockPocketManager(BlockPos pos, int size, boolean enabling) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ToggleBlockPocketManager> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("toggle_block_pocket_manager"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ToggleBlockPocketManager> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ToggleBlockPocketManager::pos, (StreamCodec)ByteBufCodecs.VAR_INT, ToggleBlockPocketManager::size, (StreamCodec)ByteBufCodecs.BOOL, ToggleBlockPocketManager::enabling, ToggleBlockPocketManager::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        BlockPocketManagerBlockEntity be;
        Player player = ctx.player();
        BlockEntity blockEntity = player.level().getBlockEntity(this.pos);
        if (blockEntity instanceof BlockPocketManagerBlockEntity && (be = (BlockPocketManagerBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            be.setSize(this.size);
            MutableComponent feedback = this.enabling ? be.enableMultiblock() : be.disableMultiblock();
            if (feedback != null) {
                if (this.enabling && !be.isEnabled()) {
                    ctx.reply((CustomPacketPayload)new BlockPocketManagerFailedActivation(this.pos));
                }
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((BlockPocketManagerBlock)((Object)SCContent.BLOCK_POCKET_MANAGER.get())).getDescriptionId(), new Object[0]), feedback, ChatFormatting.DARK_AQUA, false);
            }
            be.setChanged();
        }
    }
}

