/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncRiftStabilizer(BlockPos pos, RiftStabilizerBlockEntity.TeleportationType teleportationType, boolean allowed) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncRiftStabilizer> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("sync_rift_stabilizer"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncRiftStabilizer> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SyncRiftStabilizer::pos, (StreamCodec)NeoForgeStreamCodecs.enumCodec(RiftStabilizerBlockEntity.TeleportationType.class), SyncRiftStabilizer::teleportationType, (StreamCodec)ByteBufCodecs.BOOL, SyncRiftStabilizer::allowed, SyncRiftStabilizer::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        RiftStabilizerBlockEntity be;
        Player player;
        Level level;
        BlockEntity blockEntity;
        if (this.teleportationType != null && (blockEntity = (level = (player = ctx.player()).level()).getBlockEntity(this.pos)) instanceof RiftStabilizerBlockEntity && (be = (RiftStabilizerBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            BlockState state = level.getBlockState(this.pos);
            be.setFilter(this.teleportationType, this.allowed);
            level.sendBlockUpdated(this.pos, state, state, 2);
        }
    }
}

