/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncLaserSideConfig(BlockPos pos, CompoundTag sideConfig) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncLaserSideConfig> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("sync_laser_side_config"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncLaserSideConfig> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SyncLaserSideConfig::pos, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, SyncLaserSideConfig::sideConfig, SyncLaserSideConfig::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        LaserBlockBlockEntity be;
        Player player = ctx.player();
        Level level = player.level();
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (blockEntity instanceof LaserBlockBlockEntity && (be = (LaserBlockBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            BlockState state = level.getBlockState(this.pos);
            be.applyNewSideConfig(LaserBlockBlockEntity.loadSideConfig(this.sideConfig), player);
            level.sendBlockUpdated(this.pos, state, state, 2);
        }
    }
}

