/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncBlockPocketManager(BlockPos pos, int size, boolean showOutline, int autoBuildOffset, int color) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncBlockPocketManager> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("sync_block_pocket_manager"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncBlockPocketManager> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SyncBlockPocketManager::pos, (StreamCodec)ByteBufCodecs.VAR_INT, SyncBlockPocketManager::size, (StreamCodec)ByteBufCodecs.BOOL, SyncBlockPocketManager::showOutline, (StreamCodec)ByteBufCodecs.VAR_INT, SyncBlockPocketManager::autoBuildOffset, (StreamCodec)ByteBufCodecs.VAR_INT, SyncBlockPocketManager::color, SyncBlockPocketManager::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        BlockPocketManagerBlockEntity bpm;
        BlockEntity blockEntity;
        Player player = ctx.player();
        Level level = player.level();
        if (level.isLoaded(this.pos) && (blockEntity = level.getBlockEntity(this.pos)) instanceof BlockPocketManagerBlockEntity && (bpm = (BlockPocketManagerBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            BlockState state = level.getBlockState(this.pos);
            bpm.setSize(this.size);
            bpm.setShowOutline(this.showOutline);
            bpm.setAutoBuildOffset(this.autoBuildOffset);
            bpm.setColor(this.color);
            bpm.setChanged();
            level.sendBlockUpdated(this.pos, state, state, 2);
        }
    }
}

