/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncBlockChangeDetector(BlockPos pos, BlockChangeDetectorBlockEntity.DetectionMode mode, boolean showHighlights, int color) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncBlockChangeDetector> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("sync_block_change_detector"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncBlockChangeDetector> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SyncBlockChangeDetector::pos, (StreamCodec)NeoForgeStreamCodecs.enumCodec(BlockChangeDetectorBlockEntity.DetectionMode.class), SyncBlockChangeDetector::mode, (StreamCodec)ByteBufCodecs.BOOL, SyncBlockChangeDetector::showHighlights, (StreamCodec)ByteBufCodecs.VAR_INT, SyncBlockChangeDetector::color, SyncBlockChangeDetector::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        BlockChangeDetectorBlockEntity be;
        Player player = ctx.player();
        Level level = player.level();
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (blockEntity instanceof BlockChangeDetectorBlockEntity && (be = (BlockChangeDetectorBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            BlockState state = level.getBlockState(this.pos);
            be.setMode(this.mode);
            be.showHighlights(this.showHighlights);
            be.setColor(this.color);
            be.setChanged();
            level.sendBlockUpdated(this.pos, state, state, 2);
        }
    }
}

