/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncAlarmSettings(BlockPos pos, ResourceLocation soundEvent, float pitch, int soundLength) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncAlarmSettings> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("sync_alarm_settings"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncAlarmSettings> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SyncAlarmSettings::pos, (StreamCodec)ResourceLocation.STREAM_CODEC, SyncAlarmSettings::soundEvent, (StreamCodec)ByteBufCodecs.FLOAT, SyncAlarmSettings::pitch, (StreamCodec)ByteBufCodecs.VAR_INT, SyncAlarmSettings::soundLength, SyncAlarmSettings::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        AlarmBlockEntity be;
        Player player = ctx.player();
        BlockEntity blockEntity = player.level().getBlockEntity(this.pos);
        if (blockEntity instanceof AlarmBlockEntity && (be = (AlarmBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            if (!this.soundEvent.equals((Object)be.getSound().getLocation())) {
                be.setSound(this.soundEvent);
            }
            if (this.pitch != be.getPitch()) {
                be.setPitch(this.pitch);
            }
            if (this.soundLength != be.getSoundLength()) {
                be.setSoundLength(this.soundLength);
            }
        }
    }
}

