/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SetPasscode
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SetPasscode> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("set_passcode"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SetPasscode> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SetPasscode>(){

        public SetPasscode decode(RegistryFriendlyByteBuf buf) {
            return new SetPasscode(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, SetPasscode packet) {
            boolean hasPos = packet.pos != null;
            buf.writeBoolean(hasPos);
            if (hasPos) {
                buf.writeBlockPos(packet.pos);
            } else {
                buf.writeVarInt(packet.entityId);
            }
            buf.writeUtf(packet.passcode);
        }
    };
    private BlockPos pos;
    private int entityId;
    private String passcode;

    public SetPasscode(BlockPos pos, String passcode) {
        this.pos = pos;
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(passcode);
    }

    public SetPasscode(int entityId, String passcode) {
        this.entityId = entityId;
        this.passcode = PasscodeUtils.hashPasscodeWithoutSalt(passcode);
    }

    private SetPasscode(RegistryFriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.pos = buf.readBlockPos();
        } else {
            this.entityId = buf.readVarInt();
        }
        this.passcode = buf.readUtf(0x1FFFFFFF);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        IOwnable ownable;
        Player player = ctx.player();
        Level level = player.level();
        IPasscodeProtected passcodeProtected = this.getPasscodeProtected(level);
        if (passcodeProtected != null && (!(passcodeProtected instanceof IOwnable) || (ownable = (IOwnable)((Object)passcodeProtected)).isOwnedBy((Entity)player))) {
            passcodeProtected.hashAndSetPasscode(this.passcode, b -> passcodeProtected.openPasscodeGUI(level, this.pos, player));
            passcodeProtected.setPasscodeInAdjacentBlock(this.passcode);
        }
    }

    private IPasscodeProtected getPasscodeProtected(Level level) {
        if (this.pos != null) {
            BlockEntity blockEntity = level.getBlockEntity(this.pos);
            if (blockEntity instanceof IPasscodeProtected) {
                IPasscodeProtected pp = (IPasscodeProtected)blockEntity;
                return pp;
            }
        } else {
            Entity entity = level.getEntity(this.entityId);
            if (entity instanceof IPasscodeProtected) {
                IPasscodeProtected pp = (IPasscodeProtected)entity;
                return pp;
            }
        }
        return null;
    }
}

