/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.components.ListModuleData;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SetListModuleData(ListModuleData listModuleData) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetListModuleData> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("set_list_module_data"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SetListModuleData> STREAM_CODEC = StreamCodec.composite(ListModuleData.STREAM_CODEC, SetListModuleData::listModuleData, SetListModuleData::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        Player player = ctx.player();
        ItemStack stack = PlayerUtils.getItemStackFromAnyHand(player, (Item)SCContent.ALLOWLIST_MODULE.get());
        if (stack.isEmpty()) {
            stack = PlayerUtils.getItemStackFromAnyHand(player, (Item)SCContent.DENYLIST_MODULE.get());
        }
        if (!stack.isEmpty()) {
            stack.set(SCContent.LIST_MODULE_DATA, (Object)new ListModuleData(this.listModuleData.players().stream().distinct().toList(), this.listModuleData.teams().stream().filter(player.getScoreboard().getTeamNames()::contains).toList(), this.listModuleData.affectEveryone()));
        }
    }
}

