/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SetDefaultCameraViewingDirection(int id, float initialXRotation, float initialYRotation, float initialZoom) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetDefaultCameraViewingDirection> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("set_default_camera_viewing_direction"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SetDefaultCameraViewingDirection> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SetDefaultCameraViewingDirection::id, (StreamCodec)ByteBufCodecs.FLOAT, SetDefaultCameraViewingDirection::initialXRotation, (StreamCodec)ByteBufCodecs.FLOAT, SetDefaultCameraViewingDirection::initialYRotation, (StreamCodec)ByteBufCodecs.FLOAT, SetDefaultCameraViewingDirection::initialZoom, SetDefaultCameraViewingDirection::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        SecurityCamera camera;
        ServerPlayer player = (ServerPlayer)ctx.player();
        Entity entity = player.getCamera();
        if (entity instanceof SecurityCamera && (camera = (SecurityCamera)entity).getId() == this.id && (entity = camera.level().getBlockEntity(camera.blockPosition())) instanceof SecurityCameraBlockEntity) {
            SecurityCameraBlockEntity be = (SecurityCameraBlockEntity)entity;
            if (!be.isOwnedBy((Entity)player)) {
                player.displayClientMessage((Component)Utils.localize("messages.securitycraft:security_camera.no_permission", new Object[0]), true);
                return;
            }
            if (be.isModuleEnabled(ModuleType.SMART)) {
                be.setDefaultViewingDirection(this.initialXRotation, this.initialYRotation, this.initialZoom);
                player.displayClientMessage((Component)Utils.localize("messages.securitycraft:security_camera.direction_set", new Object[0]), true);
            } else {
                player.displayClientMessage((Component)Utils.localize("messages.securitycraft:security_camera.smart_module_needed", new Object[0]), true);
            }
        }
    }
}

