/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.logging.log4j.util.TriConsumer;

public record RemoteControlMine(BlockPos pos, Action action) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RemoteControlMine> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("remote_control_mine"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RemoteControlMine> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, RemoteControlMine::pos, (StreamCodec)NeoForgeStreamCodecs.enumCodec(Action.class), RemoteControlMine::action, RemoteControlMine::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        Player player = ctx.player();
        Level level = player.level();
        BlockState state = level.getBlockState(this.pos);
        Block block = state.getBlock();
        if (block instanceof IExplosive) {
            IOwnable be;
            IExplosive explosive = (IExplosive)block;
            block = level.getBlockEntity(this.pos);
            if (block instanceof IOwnable && (be = (IOwnable)block).isOwnedBy((Entity)player)) {
                this.action.act(explosive, level, this.pos);
            }
        }
    }

    public static enum Action {
        ACTIVATE((TriConsumer<IExplosive, Level, BlockPos>)((TriConsumer)IExplosive::activateMine)),
        DEFUSE((TriConsumer<IExplosive, Level, BlockPos>)((TriConsumer)IExplosive::defuseMine)),
        DETONATE((TriConsumer<IExplosive, Level, BlockPos>)((TriConsumer)IExplosive::explode));

        private final TriConsumer<IExplosive, Level, BlockPos> action;

        private Action(TriConsumer<IExplosive, Level, BlockPos> action) {
            this.action = action;
        }

        public void act(IExplosive explosive, Level level, BlockPos pos) {
            this.action.accept((Object)explosive, (Object)level, (Object)pos);
        }
    }
}

