/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.camera;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.platform.Window;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class}, priority=1100)
public class GameRendererMixin {
    @Shadow
    @Final
    Minecraft minecraft;

    @ModifyConstant(method={"tickFov"}, constant={@Constant(floatValue=1.0f)})
    private float securitycraft$modifyInitialFValue(float f) {
        Entity entity = this.minecraft.cameraEntity;
        if (entity instanceof SecurityCamera) {
            SecurityCamera cam = (SecurityCamera)entity;
            return cam.getZoomAmount();
        }
        return f;
    }

    @Inject(method={"render"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Options;hideGui:Z", opcode=180)})
    private void securitycraft$renderCameraTint(DeltaTracker deltaTracker, boolean renderLevel, CallbackInfo ci, @Local GuiGraphics guiGraphics) {
        if (this.minecraft.cameraEntity instanceof SecurityCamera) {
            ClientLevel level = this.minecraft.level;
            BlockPos pos = this.minecraft.cameraEntity.blockPosition();
            Window window = this.minecraft.getWindow();
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof SecurityCameraBlockEntity)) {
                return;
            }
            SecurityCameraBlockEntity be = (SecurityCameraBlockEntity)blockEntity;
            ItemStack lens = be.getLensContainer().getItem(0);
            if (lens.has(DataComponents.DYED_COLOR)) {
                guiGraphics.fill(0, 0, window.getGuiScaledWidth(), window.getGuiScaledHeight(), ((DyedItemColor)lens.get(DataComponents.DYED_COLOR)).rgb() + (be.getOpacity() << 24));
            }
        }
    }
}

